/*
 * Decompiled with CFR 0.152.
 */
package com.aoapps.lang.math;

import java.math.BigInteger;

public class UnsignedLong {
    private static final BigInteger TWO_POWER_64 = new BigInteger("10000000000000000", 16);
    private static final BigInteger TWO_POWER_64_MINUS_1 = TWO_POWER_64.subtract(BigInteger.ONE);

    private UnsignedLong() {
    }

    private static BigInteger getUnsigned(long value) {
        BigInteger bigValue = BigInteger.valueOf(value);
        if (value < 0L) {
            bigValue = bigValue.add(TWO_POWER_64).and(TWO_POWER_64_MINUS_1);
        }
        return bigValue;
    }

    public static long divide(long dividend, long divisor) {
        return UnsignedLong.getUnsigned(dividend).divide(UnsignedLong.getUnsigned(divisor)).longValue();
    }

    public static long remainder(long dividend, long divisor) {
        return UnsignedLong.getUnsigned(dividend).remainder(UnsignedLong.getUnsigned(divisor)).longValue();
    }
}

