/*
 * Decompiled with CFR 0.152.
 */
package com.aoapps.lang.reflect;

import java.util.LinkedHashSet;
import java.util.Set;

public final class Classes {
    private Classes() {
    }

    private static <T> void addAllClasses(Set<Class<? extends T>> classes, Set<Class<?>> notAssignable, Class<?> current, Class<T> upperBound) {
        while (current != null) {
            if (upperBound.isAssignableFrom(current)) {
                if (!classes.add(current.asSubclass(upperBound))) break;
                for (Class<?> iface : current.getInterfaces()) {
                    Classes.addAllClasses(classes, notAssignable, iface, upperBound);
                }
            } else {
                if (!notAssignable.add(current)) break;
                for (Class<?> iface : current.getInterfaces()) {
                    Classes.addAllClasses(classes, notAssignable, iface, upperBound);
                }
            }
            current = current.getSuperclass();
        }
    }

    public static <T> Set<Class<? extends T>> getAllClasses(Class<? extends T> clazz, Class<T> upperBound) {
        LinkedHashSet<Class<? extends T>> classes = new LinkedHashSet<Class<? extends T>>();
        LinkedHashSet notAssignable = new LinkedHashSet();
        Classes.addAllClasses(classes, notAssignable, clazz, upperBound);
        return classes;
    }

    private static void addAllClasses(Set<Class<?>> classes, Class<?> current) {
        while (current != null && classes.add(current)) {
            for (Class<?> iface : current.getInterfaces()) {
                Classes.addAllClasses(classes, iface);
            }
            current = current.getSuperclass();
        }
    }

    public static Set<Class<?>> getAllClasses(Class<?> clazz) {
        LinkedHashSet classes = new LinkedHashSet();
        Classes.addAllClasses(classes, clazz);
        return classes;
    }
}

