/*
 * Decompiled with CFR 0.152.
 */
package com.aoapps.lang.sql;

import com.aoapps.lang.EmptyArrays;
import com.aoapps.lang.Throwables;
import com.aoapps.lang.exception.LocalizedException;
import com.aoapps.lang.i18n.Resources;
import java.io.Serializable;
import java.sql.SQLException;

public class LocalizedSQLException
extends SQLException
implements LocalizedException {
    private static final long serialVersionUID = 3L;
    protected final Resources resources;
    protected final String key;
    protected final Serializable[] args;

    public LocalizedSQLException(String SQLState, int vendorCode, Resources resources, String key) {
        super(resources.getMessage(key), SQLState, vendorCode);
        this.resources = resources;
        this.key = key;
        this.args = EmptyArrays.EMPTY_SERIALIZABLE_ARRAY;
    }

    public LocalizedSQLException(String SQLState, int vendorCode, Resources resources, String key, Serializable ... args) {
        super(resources.getMessage(key, args), SQLState, vendorCode);
        this.resources = resources;
        this.key = key;
        this.args = args;
    }

    public LocalizedSQLException(String SQLState, Resources resources, String key) {
        super(resources.getMessage(key), SQLState);
        this.resources = resources;
        this.key = key;
        this.args = EmptyArrays.EMPTY_SERIALIZABLE_ARRAY;
    }

    public LocalizedSQLException(String SQLState, Resources resources, String key, Serializable ... args) {
        super(resources.getMessage(key, args), SQLState);
        this.resources = resources;
        this.key = key;
        this.args = args;
    }

    public LocalizedSQLException(String sqlState, Throwable cause, Resources resources, String key) {
        super(resources.getMessage(key), sqlState, cause);
        this.resources = resources;
        this.key = key;
        this.args = EmptyArrays.EMPTY_SERIALIZABLE_ARRAY;
    }

    public LocalizedSQLException(String sqlState, Throwable cause, Resources resources, String key, Serializable ... args) {
        super(resources.getMessage(key, args), sqlState, cause);
        this.resources = resources;
        this.key = key;
        this.args = args;
    }

    public LocalizedSQLException(String sqlState, int vendorCode, Throwable cause, Resources resources, String key) {
        super(resources.getMessage(key), sqlState, vendorCode, cause);
        this.resources = resources;
        this.key = key;
        this.args = EmptyArrays.EMPTY_SERIALIZABLE_ARRAY;
    }

    public LocalizedSQLException(String sqlState, int vendorCode, Throwable cause, Resources resources, String key, Serializable ... args) {
        super(resources.getMessage(key, args), sqlState, vendorCode, cause);
        this.resources = resources;
        this.key = key;
        this.args = args;
    }

    @Override
    public String getLocalizedMessage() {
        return this.resources.getMessage(this.key, this.args);
    }

    @Override
    public final Resources getResources() {
        return this.resources;
    }

    @Override
    public final String getKey() {
        return this.key;
    }

    @Override
    public final Serializable[] getArgs() {
        return this.args;
    }

    static {
        Throwables.registerSurrogateFactory(LocalizedSQLException.class, (template, cause) -> new LocalizedSQLException(template.getSQLState(), template.getErrorCode(), cause, template.resources, template.key, template.args));
    }
}

