/*
 * Decompiled with CFR 0.152.
 */
package com.aoapps.lang.util;

import com.aoapps.lang.exception.ExtraInfo;
import com.aoapps.lang.exception.WrappedExceptions;
import java.io.Flushable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlException;
import java.security.Permission;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class ErrorPrinter {
    private static final String EOL = System.lineSeparator();
    private static final Map<IdentityKey, List<String>> statements = new WeakHashMap<IdentityKey, List<String>>();
    private static final List<CustomMessageHandler> customMessageHandlers = new ArrayList<CustomMessageHandler>();
    private static final int LABEL_WIDTH = 18;

    private ErrorPrinter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSQL(Throwable t, String sql) {
        if (t != null && sql != null) {
            IdentityKey key = new IdentityKey(t);
            Map<IdentityKey, List<String>> map = statements;
            synchronized (map) {
                List<String> causes = statements.get(key);
                if (causes == null) {
                    causes = new ArrayList<String>();
                    statements.put(key, causes);
                }
                causes.add(sql);
            }
        }
    }

    public static void addSQL(Throwable t, PreparedStatement pstmt) {
        if (t != null && pstmt != null) {
            ErrorPrinter.addSQL(t, pstmt.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getSQL(Throwable t) {
        if (t == null) {
            return Collections.emptyList();
        }
        IdentityKey key = new IdentityKey(t);
        Map<IdentityKey, List<String>> map = statements;
        synchronized (map) {
            List<String> causes = statements.get(key);
            return causes == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<String>(causes));
        }
    }

    @Deprecated
    public static void printStackTraces(Throwable T) {
        ErrorPrinter.printStackTraces(T, System.err, (Object[])null);
    }

    @Deprecated
    public static void printStackTraces(Throwable T, Object ... extraInfo) {
        ErrorPrinter.printStackTraces(T, System.err, extraInfo);
    }

    public static void printStackTraces(Throwable T, Appendable out) {
        ErrorPrinter.printStackTraces(T, out, (Object[])null);
    }

    private static void appendln(Appendable out) {
        try {
            out.append(EOL);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void append(String S, Appendable out) {
        try {
            out.append(S);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void appendln(String S, Appendable out) {
        try {
            out.append(S);
            out.append(EOL);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void append(char ch, Appendable out) {
        try {
            out.append(ch);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void append(Object O, Appendable out) {
        ErrorPrinter.append(O == null ? "null" : O.toString(), out);
    }

    private static void appendln(Object O, Appendable out) {
        ErrorPrinter.appendln(O == null ? "null" : O.toString(), out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printStackTraces(Throwable thrown, Appendable out, Object ... extraInfo) {
        Appendable appendable = out;
        synchronized (appendable) {
            ErrorPrinter.appendln(out);
            ErrorPrinter.appendln("**************************", out);
            ErrorPrinter.appendln("* BEGIN EXCEPTION REPORT *", out);
            ErrorPrinter.appendln("**************************", out);
            ErrorPrinter.appendln(out);
            ErrorPrinter.appendln("    Time ", out);
            ErrorPrinter.append("        ", out);
            try {
                ErrorPrinter.appendln(new Date(System.currentTimeMillis()).toString(), out);
            }
            catch (Exception err) {
                ErrorPrinter.append("Unable to display date: ", out);
                ErrorPrinter.appendln(err.toString(), out);
            }
            if (extraInfo != null && extraInfo.length > 0) {
                ErrorPrinter.appendln("    Extra Information", out);
                for (Object ei : extraInfo) {
                    ErrorPrinter.append("        ", out);
                    ErrorPrinter.appendln(ei, out);
                }
            }
            ErrorPrinter.appendln("    Threading", out);
            Thread thread = Thread.currentThread();
            ErrorPrinter.appendln("        Thread", out);
            ErrorPrinter.append("            ID..........: ", out);
            ErrorPrinter.appendln(Long.toString(thread.getId()), out);
            ErrorPrinter.append("            Name........: ", out);
            ErrorPrinter.appendln(thread.getName(), out);
            ErrorPrinter.append("            Daemon......: ", out);
            ErrorPrinter.appendln(Boolean.toString(thread.isDaemon()), out);
            ErrorPrinter.append("            Class.......: ", out);
            ErrorPrinter.appendln(thread.getClass().getName(), out);
            ErrorPrinter.append("            Priority....: ", out);
            ErrorPrinter.appendln(thread.getPriority(), out);
            try {
                for (ThreadGroup TG = thread.getThreadGroup(); TG != null; TG = TG.getParent()) {
                    String name = TG.getName();
                    String classname = TG.getClass().getName();
                    int maxPriority = TG.getMaxPriority();
                    ErrorPrinter.appendln("        ThreadGroup", out);
                    ErrorPrinter.append("            Name........: ", out);
                    ErrorPrinter.appendln(name, out);
                    ErrorPrinter.append("            Class.......: ", out);
                    ErrorPrinter.appendln(classname, out);
                    ErrorPrinter.append("            Max Priority: ", out);
                    ErrorPrinter.appendln(maxPriority, out);
                }
            }
            catch (SecurityException err) {
                ErrorPrinter.append("Unable to print all Thread Groups: ", out);
                ErrorPrinter.appendln(err.toString(), out);
            }
            ErrorPrinter.appendln("    Exceptions", out);
            if (thrown == null) {
                ErrorPrinter.appendln("        No exceptions", out);
            } else {
                ArrayList<Throwable> closed = new ArrayList<Throwable>();
                closed.add(thrown);
                ErrorPrinter.printThrowables(thrown, out, 8, closed);
            }
            ErrorPrinter.appendln(out);
            ErrorPrinter.appendln("**************************", out);
            ErrorPrinter.appendln("*  END EXCEPTION REPORT  *", out);
            ErrorPrinter.appendln("**************************", out);
            try {
                if (out instanceof Flushable) {
                    ((Flushable)((Object)out)).flush();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static boolean isClosed(Throwable thrown, List<Throwable> closed) {
        for (Throwable T : closed) {
            if (T != thrown) continue;
            return true;
        }
        return false;
    }

    private static void indent(Appendable out, int indent) {
        for (int c = 0; c < indent; ++c) {
            ErrorPrinter.append(' ', out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCustomMessageHandler(CustomMessageHandler handler) {
        List<CustomMessageHandler> list = customMessageHandlers;
        synchronized (list) {
            customMessageHandlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printThrowables(Throwable thrown, Appendable out, int indent, List<Throwable> closed) {
        SQLException nextSQL;
        Throwable[] clazz2;
        Object[] extraInfo;
        String localizedMessage;
        ErrorPrinter.indent(out, indent);
        ErrorPrinter.appendln(thrown.getClass().getName(), out);
        String message = thrown.getMessage();
        if (message != null) {
            CustomMessageHandler.printMessage(out, indent + 4, "Message...........: ", message);
        }
        if ((localizedMessage = thrown.getLocalizedMessage()) != null && !localizedMessage.equals(message)) {
            CustomMessageHandler.printMessage(out, indent + 4, "Localized Message.: ", localizedMessage);
        }
        List<CustomMessageHandler> list = customMessageHandlers;
        synchronized (list) {
            for (CustomMessageHandler handler : customMessageHandlers) {
                handler.printCustomMessages(thrown, out, indent + 4);
            }
        }
        if (thrown instanceof ExtraInfo && (extraInfo = ((ExtraInfo)((Object)thrown)).getExtraInfo()) != null && extraInfo.length > 0) {
            ErrorPrinter.indent(out, indent + 4);
            ErrorPrinter.appendln("Extra Information", out);
            for (Object wi : extraInfo) {
                ErrorPrinter.indent(out, indent + 8);
                ErrorPrinter.appendln(wi, out);
            }
        }
        if (thrown instanceof SQLException) {
            SQLException sql = (SQLException)thrown;
            ErrorPrinter.indent(out, indent + 4);
            ErrorPrinter.append("SQL Error Code....: ", out);
            ErrorPrinter.appendln(sql.getErrorCode(), out);
            ErrorPrinter.indent(out, indent + 4);
            ErrorPrinter.append("SQL State.........: ", out);
            ErrorPrinter.appendln(sql.getSQLState(), out);
        } else if (thrown instanceof AccessControlException) {
            try {
                AccessControlException ace = (AccessControlException)thrown;
                Permission permission = ace.getPermission();
                ErrorPrinter.indent(out, indent + 4);
                ErrorPrinter.append("Permission........: ", out);
                ErrorPrinter.appendln(permission, out);
                if (permission != null) {
                    ErrorPrinter.indent(out, indent + 4);
                    ErrorPrinter.append("Permission Class..: ", out);
                    ErrorPrinter.appendln(permission.getClass().getName(), out);
                    ErrorPrinter.indent(out, indent + 4);
                    ErrorPrinter.append("Permission Name...: ", out);
                    ErrorPrinter.appendln(permission.getName(), out);
                    ErrorPrinter.indent(out, indent + 4);
                    ErrorPrinter.append("Permission Actions: ", out);
                    ErrorPrinter.appendln(permission.getActions(), out);
                }
            }
            catch (SecurityException err) {
                ErrorPrinter.appendln("Permission........: Unable to get permission details: ", out);
                ErrorPrinter.append(err.toString(), out);
            }
        }
        List<String> causes = ErrorPrinter.getSQL(thrown);
        int size = causes.size();
        if (size != 0) {
            String LABEL_PRE = "SQL Statement";
            StringBuilder label = new StringBuilder("SQL Statement");
            for (int i = 0; i < size; ++i) {
                label.setLength("SQL Statement".length());
                if (size != 1) {
                    label.append(" #").append(i + 1);
                }
                while (label.length() < 18) {
                    label.append('.');
                }
                label.append(": ");
                CustomMessageHandler.printMessage(out, indent + 4, label.toString(), causes.get(i));
            }
        }
        ErrorPrinter.indent(out, indent + 4);
        ErrorPrinter.appendln("Stack Trace", out);
        StackTraceElement[] stack = thrown.getStackTrace();
        for (StackTraceElement ste : stack) {
            ErrorPrinter.indent(out, indent + 8);
            ErrorPrinter.append("at ", out);
            ErrorPrinter.appendln(ste.toString(), out);
        }
        if (thrown instanceof WrappedExceptions) {
            for (Throwable cause : ((WrappedExceptions)thrown).getCauses()) {
                if (ErrorPrinter.isClosed(cause, closed)) continue;
                closed.add(cause);
                ErrorPrinter.indent(out, indent + 4);
                ErrorPrinter.appendln("Caused By", out);
                ErrorPrinter.printThrowables(cause, out, indent + 8, closed);
            }
        } else {
            Throwable cause = thrown.getCause();
            if (cause != null && !ErrorPrinter.isClosed(cause, closed)) {
                closed.add(cause);
                ErrorPrinter.indent(out, indent + 4);
                ErrorPrinter.appendln("Caused By", out);
                ErrorPrinter.printThrowables(cause, out, indent + 8, closed);
            }
        }
        try {
            Method method;
            Throwable rootCause;
            clazz2 = thrown.getClass();
            if (ErrorPrinter.isSubclass(clazz2, "javax.servlet.jsp.JspException") && (rootCause = (Throwable)(method = clazz2.getMethod("getRootCause", new Class[0])).invoke((Object)thrown, new Object[0])) != null && !ErrorPrinter.isClosed(rootCause, closed)) {
                closed.add(rootCause);
                ErrorPrinter.indent(out, indent + 4);
                ErrorPrinter.appendln("Caused By", out);
                ErrorPrinter.printThrowables(rootCause, out, indent + 8, closed);
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException clazz2) {
            // empty catch block
        }
        try {
            Method method;
            Throwable rootCause;
            clazz2 = thrown.getClass();
            if (ErrorPrinter.isSubclass(clazz2, "javax.servlet.ServletException") && (rootCause = (Throwable)(method = clazz2.getMethod("getRootCause", new Class[0])).invoke((Object)thrown, new Object[0])) != null && !ErrorPrinter.isClosed(rootCause, closed)) {
                closed.add(rootCause);
                ErrorPrinter.indent(out, indent + 4);
                ErrorPrinter.appendln("Caused By", out);
                ErrorPrinter.printThrowables(rootCause, out, indent + 8, closed);
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException clazz3) {
            // empty catch block
        }
        for (Throwable suppressed : thrown.getSuppressed()) {
            if (ErrorPrinter.isClosed(suppressed, closed)) continue;
            closed.add(suppressed);
            ErrorPrinter.indent(out, indent + 4);
            ErrorPrinter.appendln("Suppressed", out);
            ErrorPrinter.printThrowables(suppressed, out, indent + 8, closed);
        }
        if (thrown instanceof SQLException && (nextSQL = ((SQLException)thrown).getNextException()) != null) {
            ArrayList<SQLException> nextSQLs = new ArrayList<SQLException>();
            do {
                if (ErrorPrinter.isClosed(nextSQL, closed)) continue;
                nextSQLs.add(nextSQL);
            } while ((nextSQL = nextSQL.getNextException()) != null);
            closed.addAll(nextSQLs);
            for (SQLException next : nextSQLs) {
                ErrorPrinter.printThrowables(next, out, indent, closed);
            }
        }
    }

    private static boolean isSubclass(Class<?> clazz, String classname) {
        while (clazz != null) {
            if (clazz.getName().equals(classname)) {
                return true;
            }
            clazz = clazz.getSuperclass();
        }
        return false;
    }

    public static String getStackTraces(Throwable T) {
        return ErrorPrinter.getStackTraces(T, null);
    }

    public static String getStackTraces(Throwable thrown, Object ... extraInfo) {
        StringBuilder out = new StringBuilder();
        ErrorPrinter.printStackTraces(thrown, out, extraInfo);
        return out.toString();
    }

    @FunctionalInterface
    public static interface CustomMessageHandler {
        public static void printMessage(Appendable out, int indent, String label, String message) {
            if (label != null || message != null) {
                ErrorPrinter.indent(out, indent);
                if (label != null) {
                    ErrorPrinter.append(label, out);
                }
                if (message == null) {
                    if (!2.$assertionsDisabled && label == null) {
                        throw new AssertionError();
                    }
                    ErrorPrinter.appendln("null", out);
                } else {
                    message = message.trim();
                    int messageLen = message.length();
                    for (int c = 0; c < messageLen; ++c) {
                        char ch = message.charAt(c);
                        if (ch == '\n') {
                            ErrorPrinter.appendln(out);
                            ErrorPrinter.indent(out, indent + (label == null ? 0 : label.length()));
                            continue;
                        }
                        if (ch == '\r') continue;
                        ErrorPrinter.append(ch, out);
                    }
                    ErrorPrinter.appendln(out);
                }
            }
        }

        public void printCustomMessages(Throwable var1, Appendable var2, int var3);

        static {
            if (2.$assertionsDisabled) {
                // empty if block
            }
        }
    }

    private static class IdentityKey {
        private final Throwable t;

        private IdentityKey(Throwable t) {
            this.t = t;
        }

        public int hashCode() {
            return System.identityHashCode(this.t);
        }

        public boolean equals(Object obj) {
            return this == obj;
        }
    }
}

