/*
 * ao-lang - Minimal Java library with no external dependencies shared by many other projects.
 * Copyright (C) 2002, 2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2017, 2021, 2022  AO Industries, Inc.
 *     support@aoindustries.com
 *     7262 Bull Pen Cir
 *     Mobile, AL 36695
 *
 * This file is part of ao-lang.
 *
 * ao-lang is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * ao-lang is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with ao-lang.  If not, see <https://www.gnu.org/licenses/>.
 */

package com.aoapps.lang.io;

import java.io.OutputStream;

/**
 * Discards all data.
 */
public final class NullOutputStream extends OutputStream implements NoClose {

  private static final NullOutputStream instance = new NullOutputStream();

  public static NullOutputStream getInstance() {
    return instance;
  }

  private NullOutputStream() {
    // Do nothing
  }

  @Override
  public void close() {
    // Do nothing
  }

  @Override
  public void flush() {
    // Do nothing
  }

  @Override
  public void write(byte[] b) {
    // Do nothing
  }

  @Override
  public void write(byte[] b, int off, int len) {
    // Do nothing
  }

  @Override
  public void write(int b) {
    // Do nothing
  }
}
