/*
 * Decompiled with CFR 0.152.
 */
package com.aoapps.lang;

import com.aoapps.lang.Throwables;
import java.util.function.Function;

public final class AutoCloseables {
    private AutoCloseables() {
        throw new AssertionError();
    }

    public static Throwable closeAndCatch(Throwable t0, AutoCloseable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable t) {
                t0 = Throwables.addSuppressed(t0, t);
            }
        }
        return t0;
    }

    public static Throwable closeAndCatch(AutoCloseable closeable) {
        return AutoCloseables.closeAndCatch(null, closeable);
    }

    public static Throwable closeAndCatch(Throwable t0, AutoCloseable ... closeable) {
        if (closeable != null) {
            for (AutoCloseable ac : closeable) {
                t0 = AutoCloseables.closeAndCatch(t0, ac);
            }
        }
        return t0;
    }

    public static Throwable closeAndCatch(AutoCloseable ... closeable) {
        return AutoCloseables.closeAndCatch(null, closeable);
    }

    public static Throwable closeAndCatch(Throwable t0, Iterable<? extends AutoCloseable> closeable) {
        if (closeable != null) {
            for (AutoCloseable autoCloseable : closeable) {
                t0 = AutoCloseables.closeAndCatch(t0, autoCloseable);
            }
        }
        return t0;
    }

    public static Throwable closeAndCatch(Iterable<? extends AutoCloseable> closeable) {
        return AutoCloseables.closeAndCatch(null, closeable);
    }

    public static <Ex extends Throwable> void closeAndThrow(Throwable t0, Class<? extends Ex> exClass, Function<? super Throwable, ? extends Ex> exSupplier, AutoCloseable closeable) throws Error, RuntimeException, Ex {
        Throwable t = AutoCloseables.closeAndCatch(t0, closeable);
        if (t != null) {
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (exClass.isInstance(t)) {
                throw (Throwable)exClass.cast(t);
            }
            Throwable newExc = (Throwable)exSupplier.apply(t);
            if (t instanceof InterruptedException && !(newExc instanceof InterruptedException)) {
                Thread.currentThread().interrupt();
            }
            throw newExc;
        }
    }

    public static <Ex extends Throwable> void closeAndThrow(Class<? extends Ex> exClass, Function<? super Throwable, ? extends Ex> exSupplier, AutoCloseable closeable) throws Error, RuntimeException, Ex {
        AutoCloseables.closeAndThrow(null, exClass, exSupplier, closeable);
    }

    public static <Ex extends Throwable> void closeAndThrow(Throwable t0, Class<? extends Ex> exClass, Function<? super Throwable, ? extends Ex> exSupplier, AutoCloseable ... closeable) throws Error, RuntimeException, Ex {
        Throwable t = AutoCloseables.closeAndCatch(t0, closeable);
        if (t != null) {
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (exClass.isInstance(t)) {
                throw (Throwable)exClass.cast(t);
            }
            Throwable newExc = (Throwable)exSupplier.apply(t);
            if (t instanceof InterruptedException && !(newExc instanceof InterruptedException)) {
                Thread.currentThread().interrupt();
            }
            throw newExc;
        }
    }

    public static <Ex extends Throwable> void closeAndThrow(Class<? extends Ex> exClass, Function<? super Throwable, ? extends Ex> exSupplier, AutoCloseable ... closeable) throws Error, RuntimeException, Ex {
        AutoCloseables.closeAndThrow(null, exClass, exSupplier, closeable);
    }

    public static <Ex extends Throwable> void closeAndThrow(Throwable t0, Class<? extends Ex> exClass, Function<? super Throwable, ? extends Ex> exSupplier, Iterable<? extends AutoCloseable> closeable) throws Error, RuntimeException, Ex {
        Throwable t = AutoCloseables.closeAndCatch(t0, closeable);
        if (t != null) {
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (exClass.isInstance(t)) {
                throw (Throwable)exClass.cast(t);
            }
            Throwable newExc = (Throwable)exSupplier.apply(t);
            if (t instanceof InterruptedException && !(newExc instanceof InterruptedException)) {
                Thread.currentThread().interrupt();
            }
            throw newExc;
        }
    }

    public static <Ex extends Throwable> void closeAndThrow(Class<? extends Ex> exClass, Function<? super Throwable, ? extends Ex> exSupplier, Iterable<? extends AutoCloseable> closeable) throws Error, RuntimeException, Ex {
        AutoCloseables.closeAndThrow(null, exClass, exSupplier, closeable);
    }

    public static <Ex extends Throwable> Ex closeAndWrap(Throwable t0, Class<? extends Ex> exClass, Function<? super Throwable, ? extends Ex> exSupplier, AutoCloseable closeable) {
        return Throwables.wrap(AutoCloseables.closeAndCatch(t0, closeable), exClass, exSupplier);
    }

    public static <Ex extends Throwable> Ex closeAndWrap(Throwable t0, Class<? extends Ex> exClass, Function<? super Throwable, ? extends Ex> exSupplier, AutoCloseable ... closeable) {
        return Throwables.wrap(AutoCloseables.closeAndCatch(t0, closeable), exClass, exSupplier);
    }

    public static <Ex extends Throwable> Ex closeAndWrap(Throwable t0, Class<? extends Ex> exClass, Function<? super Throwable, ? extends Ex> exSupplier, Iterable<? extends AutoCloseable> closeable) {
        return Throwables.wrap(AutoCloseables.closeAndCatch(t0, closeable), exClass, exSupplier);
    }
}

