/*
 * Decompiled with CFR 0.152.
 */
package com.aoapps.lang;

import com.aoapps.lang.CoercionOptimizer;
import com.aoapps.lang.CoercionOptimizerInitializer;
import com.aoapps.lang.Strings;
import com.aoapps.lang.exception.WrappedException;
import com.aoapps.lang.io.AppendableWriter;
import com.aoapps.lang.io.Encoder;
import com.aoapps.lang.io.EncoderWriter;
import com.aoapps.lang.io.Writable;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Segment;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;

public final class Coercion {
    private static final Logger logger = Logger.getLogger(Coercion.class.getName());
    private static final Object optimizersLock = new Object();
    private static volatile CoercionOptimizer[] optimizers = new CoercionOptimizer[0];

    private Coercion() {
        throw new AssertionError();
    }

    public static String toString(Object value) {
        while (value instanceof Optional) {
            value = ((Optional)value).orElse(null);
        }
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Writable) {
            return value.toString();
        }
        if (value instanceof CharSequence) {
            return value.toString();
        }
        if (value instanceof char[]) {
            char[] chs = (char[])value;
            return chs.length == 0 ? "" : new String(chs);
        }
        if (value instanceof Node) {
            try {
                TransformerFactory transFactory = TransformerFactory.newInstance();
                try {
                    transFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                }
                catch (TransformerConfigurationException e) {
                    throw new AssertionError("All implementations are required to support the javax.xml.XMLConstants.FEATURE_SECURE_PROCESSING feature.", e);
                }
                transFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                transFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
                Transformer transformer = transFactory.newTransformer();
                StringWriter buffer = new StringWriter();
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                transformer.setOutputProperty("encoding", StandardCharsets.UTF_8.name());
                transformer.transform(new DOMSource((Node)value), new StreamResult(buffer));
                return buffer.toString();
            }
            catch (TransformerException e) {
                throw new WrappedException(e);
            }
        }
        return value.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerOptimizer(CoercionOptimizer optimizer) {
        Object object = optimizersLock;
        synchronized (object) {
            CoercionOptimizer[] newOptimizer = Arrays.copyOf(optimizers, optimizers.length + 1);
            newOptimizer[newOptimizer.length - 1] = optimizer;
            optimizers = newOptimizer;
        }
    }

    public static Writer optimize(Writer out, Encoder encoder) {
        Writer original = out;
        Writer newOut = out;
        while (true) {
            for (CoercionOptimizer optimizer : optimizers) {
                newOut = optimizer.optimize(newOut, encoder);
            }
            if (newOut == out) break;
            out = newOut;
        }
        if (newOut != original && logger.isLoggable(Level.FINER)) {
            logger.finer("Writer optimized from " + original.getClass().getName() + " to " + newOut.getClass().getName() + " with encoder " + (encoder == null ? null : encoder.getClass().getName()));
        }
        return newOut;
    }

    public static Appendable optimize(Appendable out, Encoder encoder) {
        if (out instanceof Writer) {
            return Coercion.optimize((Writer)out, encoder);
        }
        return out;
    }

    public static void write(Object value, Writer out) throws IOException {
        Coercion.write(value, out, false);
    }

    public static void write(Object value, Writer out, boolean outOptimized) throws IOException {
        while (value instanceof Optional) {
            value = ((Optional)value).orElse(null);
        }
        if (value != null) {
            assert (out != null);
            if (out instanceof EncoderWriter) {
                EncoderWriter encoderWriter = (EncoderWriter)out;
                Coercion.write(value, encoderWriter.getEncoder(), encoderWriter.getOut(), true);
            } else {
                Writer optimized;
                if (outOptimized) {
                    optimized = out;
                    assert (optimized == Coercion.optimize(out, null));
                } else {
                    optimized = Coercion.optimize(out, null);
                }
                if (value instanceof String) {
                    optimized.write((String)value);
                } else if (value instanceof Writable) {
                    Writable writable = (Writable)value;
                    if (writable.isFastToString()) {
                        optimized.write(writable.toString());
                    } else {
                        writable.writeTo(optimized);
                    }
                } else if (value instanceof Segment) {
                    Segment s = (Segment)value;
                    optimized.write(s.array, s.offset, s.count);
                } else if (value instanceof CharSequence) {
                    optimized.append((CharSequence)value);
                } else if (value instanceof char[]) {
                    optimized.write((char[])value);
                } else {
                    if (value instanceof Node) {
                        try {
                            TransformerFactory transFactory = TransformerFactory.newInstance();
                            try {
                                transFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                            }
                            catch (TransformerConfigurationException e) {
                                throw new AssertionError("All implementations are required to support the javax.xml.XMLConstants.FEATURE_SECURE_PROCESSING feature.", e);
                            }
                            transFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                            transFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
                            Transformer transformer = transFactory.newTransformer();
                            transformer.setOutputProperty("omit-xml-declaration", "yes");
                            transformer.setOutputProperty("encoding", StandardCharsets.UTF_8.name());
                            transformer.transform(new DOMSource((Node)value), new StreamResult(optimized));
                        }
                        catch (TransformerException e) {
                            throw new IOException(e);
                        }
                    }
                    optimized.write(value.toString());
                }
            }
        }
    }

    public static void write(Object value, Encoder encoder, Writer out) throws IOException {
        Coercion.write(value, encoder, out, false);
    }

    public static void write(Object value, Encoder encoder, Writer out, boolean outOptimized) throws IOException {
        if (encoder == null) {
            Coercion.write(value, out, outOptimized);
        } else {
            while (value instanceof Optional) {
                value = ((Optional)value).orElse(null);
            }
            if (value != null) {
                Writer optimized;
                if (outOptimized) {
                    optimized = out;
                    assert (optimized == Coercion.optimize(out, encoder));
                } else {
                    optimized = Coercion.optimize(out, encoder);
                }
                if (value instanceof String) {
                    encoder.write((String)value, optimized);
                } else if (value instanceof Writable) {
                    Writable writable = (Writable)value;
                    if (writable.isFastToString()) {
                        encoder.write(writable.toString(), optimized);
                    } else {
                        writable.writeTo(encoder, optimized);
                    }
                } else if (value instanceof Segment) {
                    Segment s = (Segment)value;
                    encoder.write(s.array, s.offset, s.count, optimized);
                } else if (value instanceof CharSequence) {
                    encoder.append((CharSequence)value, (Appendable)optimized);
                } else if (value instanceof char[]) {
                    encoder.write((char[])value, optimized);
                } else {
                    if (value instanceof Node) {
                        try {
                            TransformerFactory transFactory = TransformerFactory.newInstance();
                            try {
                                transFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                            }
                            catch (TransformerConfigurationException e) {
                                throw new AssertionError("All implementations are required to support the javax.xml.XMLConstants.FEATURE_SECURE_PROCESSING feature.", e);
                            }
                            transFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                            transFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
                            Transformer transformer = transFactory.newTransformer();
                            transformer.setOutputProperty("omit-xml-declaration", "yes");
                            transformer.setOutputProperty("encoding", StandardCharsets.UTF_8.name());
                            transformer.transform(new DOMSource((Node)value), new StreamResult(new EncoderWriter(encoder, optimized, true)));
                        }
                        catch (TransformerException e) {
                            throw new IOException(e);
                        }
                    }
                    encoder.write(value.toString(), optimized);
                }
            }
        }
    }

    public static void append(Object value, Appendable out) throws IOException {
        Coercion.append(value, out, false);
    }

    public static void append(Object value, Appendable out, boolean outOptimized) throws IOException {
        assert (out != null);
        if (out instanceof Writer) {
            Coercion.write(value, (Writer)out, outOptimized);
        } else {
            while (value instanceof Optional) {
                value = ((Optional)value).orElse(null);
            }
            if (value != null) {
                Appendable optimized;
                if (outOptimized) {
                    optimized = out;
                    assert (optimized == Coercion.optimize(out, null));
                } else {
                    optimized = Coercion.optimize(out, null);
                }
                if (value instanceof String) {
                    optimized.append((String)value);
                } else if (value instanceof Writable) {
                    Writable writable = (Writable)value;
                    if (writable.isFastToString()) {
                        optimized.append(writable.toString());
                    } else {
                        writable.appendTo(optimized);
                    }
                } else if (value instanceof CharSequence) {
                    optimized.append((CharSequence)value);
                } else if (value instanceof char[]) {
                    char[] chs = (char[])value;
                    int chsLen = chs.length;
                    if (chsLen > 0) {
                        optimized.append(new Segment(chs, 0, chsLen));
                    }
                } else {
                    if (value instanceof Node) {
                        try {
                            TransformerFactory transFactory = TransformerFactory.newInstance();
                            try {
                                transFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                            }
                            catch (TransformerConfigurationException e) {
                                throw new AssertionError("All implementations are required to support the javax.xml.XMLConstants.FEATURE_SECURE_PROCESSING feature.", e);
                            }
                            transFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                            transFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
                            Transformer transformer = transFactory.newTransformer();
                            transformer.setOutputProperty("omit-xml-declaration", "yes");
                            transformer.setOutputProperty("encoding", StandardCharsets.UTF_8.name());
                            transformer.transform(new DOMSource((Node)value), new StreamResult(AppendableWriter.wrap(optimized)));
                        }
                        catch (TransformerException e) {
                            throw new IOException(e);
                        }
                    }
                    optimized.append(value.toString());
                }
            }
        }
    }

    public static void append(Object value, Encoder encoder, Appendable out) throws IOException {
        Coercion.append(value, encoder, out, false);
    }

    public static void append(Object value, Encoder encoder, Appendable out, boolean outOptimized) throws IOException {
        if (encoder == null) {
            Coercion.append(value, out, outOptimized);
        } else if (out instanceof Writer) {
            Coercion.write(value, encoder, (Writer)out, outOptimized);
        } else {
            while (value instanceof Optional) {
                value = ((Optional)value).orElse(null);
            }
            if (value != null) {
                Appendable optimized;
                if (outOptimized) {
                    optimized = out;
                    assert (optimized == Coercion.optimize(out, encoder));
                } else {
                    optimized = Coercion.optimize(out, encoder);
                }
                if (value instanceof String) {
                    encoder.append((String)value, optimized);
                } else if (value instanceof Writable) {
                    Writable writable = (Writable)value;
                    if (writable.isFastToString()) {
                        encoder.append(writable.toString(), optimized);
                    } else {
                        writable.appendTo(encoder, optimized);
                    }
                } else if (value instanceof CharSequence) {
                    encoder.append((CharSequence)value, optimized);
                } else if (value instanceof char[]) {
                    char[] chs = (char[])value;
                    int chsLen = chs.length;
                    if (chsLen > 0) {
                        encoder.append(new Segment(chs, 0, chsLen), optimized);
                    }
                } else {
                    if (value instanceof Node) {
                        try {
                            TransformerFactory transFactory = TransformerFactory.newInstance();
                            try {
                                transFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                            }
                            catch (TransformerConfigurationException e) {
                                throw new AssertionError("All implementations are required to support the javax.xml.XMLConstants.FEATURE_SECURE_PROCESSING feature.", e);
                            }
                            transFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                            transFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
                            Transformer transformer = transFactory.newTransformer();
                            transformer.setOutputProperty("omit-xml-declaration", "yes");
                            transformer.setOutputProperty("encoding", StandardCharsets.UTF_8.name());
                            transformer.transform(new DOMSource((Node)value), new StreamResult(new EncoderWriter(encoder, AppendableWriter.wrap(optimized), true)));
                        }
                        catch (TransformerException e) {
                            throw new IOException(e);
                        }
                    }
                    encoder.append(value.toString(), optimized);
                }
            }
        }
    }

    public static boolean isEmpty(Object value) throws IOException {
        while (value instanceof Optional) {
            value = ((Optional)value).orElse(null);
        }
        if (value == null) {
            return true;
        }
        if (value instanceof String) {
            return ((String)value).isEmpty();
        }
        if (value instanceof Writable) {
            return ((Writable)value).getLength() == 0L;
        }
        if (value instanceof CharSequence) {
            return ((CharSequence)value).length() == 0;
        }
        if (value instanceof char[]) {
            return ((char[])value).length == 0;
        }
        if (value instanceof Node) {
            return false;
        }
        return value.toString().isEmpty();
    }

    public static Object nullIfEmpty(Object value) throws IOException {
        while (value instanceof Optional) {
            value = ((Optional)value).orElse(null);
        }
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return Strings.nullIfEmpty((String)value);
        }
        if (value instanceof Writable) {
            return ((Writable)value).getLength() == 0L ? null : value;
        }
        if (value instanceof CharSequence) {
            return ((CharSequence)value).length() == 0 ? null : value;
        }
        if (value instanceof char[]) {
            return ((char[])value).length == 0 ? null : value;
        }
        if (value instanceof Node) {
            return value;
        }
        return Strings.nullIfEmpty(value.toString());
    }

    public static Object trim(Object value) throws IOException {
        while (value instanceof Optional) {
            value = ((Optional)value).orElse(null);
        }
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return Strings.trim((String)value);
        }
        if (value instanceof Writable) {
            Writable writable = (Writable)value;
            if (writable.isFastToString()) {
                return Strings.trim(writable.toString());
            }
            return writable.trim();
        }
        if (value instanceof CharSequence) {
            CharSequence cs = Strings.trim((CharSequence)value);
            return cs.length() == 0 ? "" : cs;
        }
        if (value instanceof char[]) {
            char[] chs = (char[])value;
            int chsLen = chs.length;
            if (chsLen == 0) {
                return "";
            }
            CharSequence cs = Strings.trim(new Segment(chs, 0, chsLen));
            return cs.length() == 0 ? "" : (cs.length() == chsLen ? (Object)chs : cs);
        }
        if (value instanceof Node) {
            return value;
        }
        return Strings.trim(value.toString());
    }

    public static Object trimNullIfEmpty(Object value) throws IOException {
        while (value instanceof Optional) {
            value = ((Optional)value).orElse(null);
        }
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return Strings.trimNullIfEmpty((String)value);
        }
        if (value instanceof Writable) {
            Writable writable = (Writable)value;
            if (writable.isFastToString()) {
                return Strings.trimNullIfEmpty(writable.toString());
            }
            return (writable = writable.trim()).getLength() == 0L ? null : writable;
        }
        if (value instanceof CharSequence) {
            return Strings.trimNullIfEmpty((CharSequence)value);
        }
        if (value instanceof char[]) {
            char[] chs = (char[])value;
            int chsLen = chs.length;
            if (chsLen == 0) {
                return null;
            }
            CharSequence cs = Strings.trimNullIfEmpty(new Segment(chs, 0, chsLen));
            return cs == null ? null : (cs.length() == chsLen ? chs : (char[])cs);
        }
        if (value instanceof Node) {
            return value;
        }
        return Strings.trimNullIfEmpty(value.toString());
    }

    static {
        for (CoercionOptimizerInitializer initializer : ServiceLoader.load(CoercionOptimizerInitializer.class)) {
            initializer.run();
        }
    }
}

