/*
 * Decompiled with CFR 0.152.
 */
package com.aoapps.lang.attribute;

import com.aoapps.lang.attribute.Context;
import com.aoapps.lang.attribute.Scope;
import com.aoapps.lang.function.BiFunctionE;
import com.aoapps.lang.function.FunctionE;
import java.io.Serializable;
import java.util.Iterator;
import java.util.ServiceLoader;

public abstract class Attribute<C, T> {
    protected final String name;

    protected Attribute(String name) {
        this.name = name;
    }

    public abstract Context<C> getContext();

    public String getName() {
        return this.name;
    }

    public abstract OldValue init(T var1);

    public abstract <Ex extends Throwable> T compute(BiFunctionE<? super String, ? super T, ? extends T, ? extends Ex> var1) throws Ex;

    public abstract <Ex extends Throwable> T computeIfAbsent(FunctionE<? super String, ? extends T, ? extends Ex> var1) throws Ex;

    public abstract <Ex extends Throwable> T computeIfPresent(BiFunctionE<? super String, ? super T, ? extends T, ? extends Ex> var1) throws Ex;

    public abstract T get();

    public abstract T getOrDefault(T var1);

    public abstract <Ex extends Throwable> T merge(T var1, BiFunctionE<? super T, ? super T, ? extends T, ? extends Ex> var2) throws Ex;

    public abstract void remove();

    public abstract boolean remove(T var1);

    public abstract T replace(T var1);

    public abstract boolean replace(T var1, T var2);

    public abstract void set(T var1);

    public abstract T setIfAbsent(T var1);

    public static <T> Name<T> attribute(String name) {
        return new Name(name);
    }

    public static class Name<T>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected final String name;

        protected Name(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public <C> Scope.Attribute<C, T> scope(Class<C> contextType) {
            ServiceLoader<ContextFactory> loader = ServiceLoader.load(ContextFactory.class);
            Iterator<ContextFactory> iter = loader.iterator();
            while (iter.hasNext()) {
                Scope.Attribute attribute = ((ScopeFactory)((Object)iter.next())).attribute(contextType, this.name);
                if (attribute == null) continue;
                return attribute;
            }
            throw new IllegalArgumentException("No factory registered for scope for context type \"" + (contextType == null ? "null" : contextType.toGenericString()) + "\"");
        }

        public <C> Scope.Attribute<C, T> scope(Scope<C> scope) {
            return scope.attribute(this.name);
        }

        public <C> Attribute<C, T> context(C context) {
            ServiceLoader<ContextFactory> loader = ServiceLoader.load(ContextFactory.class);
            Iterator<ContextFactory> iter = loader.iterator();
            while (iter.hasNext()) {
                Attribute attribute = iter.next().attribute(context, this.name);
                if (attribute == null) continue;
                return attribute;
            }
            throw new IllegalArgumentException("No factory registered for context of type \"" + (context == null ? "null" : context.getClass().toGenericString()) + "\": " + context);
        }

        @FunctionalInterface
        public static interface ContextFactory<C, T> {
            public Attribute<C, T> attribute(Object var1, String var2);
        }

        @FunctionalInterface
        public static interface ScopeFactory<C, T> {
            public Scope.Attribute<C, T> attribute(Class<?> var1, String var2);
        }
    }

    public static abstract class OldValue
    implements AutoCloseable {
        private final Object oldValue;

        protected OldValue(Object oldValue) {
            this.oldValue = oldValue;
        }

        public Object getOldValue() {
            return this.oldValue;
        }

        @Override
        public abstract void close();
    }
}

