/*
 * Decompiled with CFR 0.152.
 */
package com.aoapps.lang.function;

import java.util.Objects;

@FunctionalInterface
public interface PredicateE<T, Ex extends Throwable> {
    public boolean test(T var1) throws Ex;

    default public PredicateE<T, Ex> and(PredicateE<? super T, ? extends Ex> other) throws Ex {
        Objects.requireNonNull(other);
        return t -> this.test(t) && other.test(t);
    }

    default public PredicateE<T, Ex> negate() throws Ex {
        return t -> !this.test(t);
    }

    default public PredicateE<T, Ex> or(PredicateE<? super T, ? extends Ex> other) throws Ex {
        Objects.requireNonNull(other);
        return t -> this.test(t) || other.test(t);
    }

    public static <T, Ex extends Throwable> PredicateE<T, Ex> isEqual(Object targetRef) {
        return null == targetRef ? Objects::isNull : targetRef::equals;
    }

    public static <T, Ex extends Throwable> PredicateE<T, Ex> not(PredicateE<? super T, ? extends Ex> target) throws Ex {
        Objects.requireNonNull(target);
        return target.negate();
    }
}

