/*
 * Decompiled with CFR 0.152.
 */
package com.aoapps.lang.i18n;

import com.aoapps.lang.i18n.CurrencyComparator;
import com.aoapps.lang.i18n.CurrencyUtil;
import com.aoapps.lang.i18n.ThreadLocale;
import com.aoapps.lang.io.FastExternalizable;
import com.aoapps.lang.io.FastObjectInput;
import com.aoapps.lang.io.FastObjectOutput;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Currency;
import java.util.Locale;

public final class Money
implements FastExternalizable,
Comparable<Money> {
    private Currency currency;
    private long value;
    private int scale;
    private static final long serialVersionUID = 2287045704444180509L;

    public static BigDecimal parseMoneyAmount(Locale locale, String symbol, String value) throws NumberFormatException {
        if (value == null) {
            return null;
        }
        value = value.trim();
        value = value.replace('\u00a0', ' ');
        if (symbol != null && !symbol.isEmpty()) {
            symbol = symbol.replace('\u00a0', ' ');
            while (value.startsWith(symbol)) {
                value = value.substring(symbol.length()).trim();
            }
            while (value.endsWith(symbol)) {
                value = value.substring(0, value.length() - symbol.length()).trim();
            }
        }
        value = Locale.FRENCH.getLanguage().equals(locale.getLanguage()) ? value.replace(".", "").replace(',', '.').trim() : value.replace(",", "").trim();
        return value.isEmpty() ? null : new BigDecimal(value);
    }

    public static Money parseMoney(Currency currency, Locale locale, String value) {
        BigDecimal amount = Money.parseMoneyAmount(locale, currency == null ? null : CurrencyUtil.getSymbol(currency, locale), value);
        return amount == null ? null : new Money(currency, amount);
    }

    public Money(Currency currency, BigDecimal value) throws NumberFormatException {
        this.currency = currency;
        try {
            int currencyScale = currency.getDefaultFractionDigits();
            if (currencyScale != -1) {
                value = value.setScale(currencyScale);
            }
            this.scale = value.scale();
            this.value = value.movePointRight(value.scale()).longValueExact();
        }
        catch (ArithmeticException err) {
            NumberFormatException newErr = new NumberFormatException(err.getMessage());
            newErr.initCause(err);
            throw newErr;
        }
        this.validate();
    }

    public Money(Currency currency, long value, int scale) throws NumberFormatException {
        this.currency = currency;
        try {
            int currencyScale = currency.getDefaultFractionDigits();
            if (currencyScale != -1 && currencyScale != scale) {
                value = value == 0L ? 0L : BigDecimal.valueOf(value, scale).setScale(currencyScale).movePointRight(currencyScale).longValueExact();
                scale = currencyScale;
            }
            this.value = value;
            this.scale = scale;
        }
        catch (ArithmeticException err) {
            NumberFormatException newErr = new NumberFormatException(err.getMessage());
            newErr.initCause(err);
            throw newErr;
        }
        this.validate();
    }

    private void validate() throws NumberFormatException {
        int currencyScale = this.currency.getDefaultFractionDigits();
        if (currencyScale != -1 && currencyScale != this.scale) {
            throw new NumberFormatException("currency.scale != value.scale: " + currencyScale + " != " + this.scale);
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof Money)) {
            return false;
        }
        Money other = (Money)o;
        return this.currency == other.currency && this.value == other.value && this.scale == other.scale;
    }

    public int hashCode() {
        int hash = this.currency.getCurrencyCode().hashCode();
        hash = hash * 31 + (int)this.value;
        hash = hash * 31 + this.scale;
        return hash;
    }

    @Override
    public int compareTo(Money other) {
        int diff = CurrencyComparator.getInstance().compare(this.currency, other.currency);
        if (diff != 0) {
            return diff;
        }
        if (this.scale == other.scale) {
            return Long.compare(this.value, other.value);
        }
        return this.getValue().compareTo(other.getValue());
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public BigDecimal getValue() {
        return BigDecimal.valueOf(this.value, this.scale);
    }

    public long getUnscaledValue() {
        return this.value;
    }

    public int getScale() {
        return this.scale;
    }

    public String toString() {
        Locale locale = ThreadLocale.get();
        String symbol = CurrencyUtil.getSymbol(this.currency, locale);
        String amount = this.getValue().toPlainString();
        if (Locale.FRENCH.getLanguage().equals(locale.getLanguage())) {
            return amount.replace('.', ',') + '\u00a0' + symbol;
        }
        return symbol + amount;
    }

    public Money add(Money addend) throws ArithmeticException {
        if (this.currency != addend.currency) {
            throw new ArithmeticException("currency != addend.currency: " + this.currency + " != " + addend.currency);
        }
        return new Money(this.currency, this.getValue().add(addend.getValue()));
    }

    public Money multiply(BigDecimal multiplicand) throws ArithmeticException {
        return this.multiply(multiplicand, RoundingMode.UNNECESSARY);
    }

    public Money multiply(BigDecimal multiplicand, RoundingMode roundingMode) throws ArithmeticException {
        int currencyScale = this.currency.getDefaultFractionDigits();
        if (currencyScale == -1) {
            currencyScale = this.scale;
        }
        return new Money(this.currency, this.getValue().multiply(multiplicand).setScale(currencyScale, roundingMode));
    }

    public Money negate() {
        return new Money(this.currency, this.getValue().negate());
    }

    public Money subtract(Money subtrahend) throws ArithmeticException {
        if (this.currency != subtrahend.currency) {
            throw new ArithmeticException("currency != subtrahend.currency: " + this.currency + " != " + subtrahend.currency);
        }
        return new Money(this.currency, this.getValue().subtract(subtrahend.getValue()));
    }

    @Deprecated
    public Money() {
    }

    @Override
    public long getSerialVersionUID() {
        return 2287045704444180509L;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        FastObjectOutput fastOut = FastObjectOutput.wrap(out);
        try {
            fastOut.writeFastUTF(this.currency.getCurrencyCode());
            fastOut.writeLong(this.value);
            fastOut.writeInt(this.scale);
        }
        finally {
            fastOut.unwrap();
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        if (this.currency != null) {
            throw new IllegalStateException();
        }
        FastObjectInput fastIn = FastObjectInput.wrap(in);
        try {
            this.currency = Currency.getInstance(fastIn.readFastUTF());
            this.value = fastIn.readLong();
            this.scale = fastIn.readInt();
        }
        finally {
            fastIn.unwrap();
        }
        try {
            this.validate();
        }
        catch (NumberFormatException err) {
            InvalidObjectException newErr = new InvalidObjectException(err.getMessage());
            newErr.initCause(err);
            throw newErr;
        }
    }
}

