/*
 * Decompiled with CFR 0.152.
 */
package com.aoapps.lang.io;

import com.aoapps.lang.io.FastExternalizable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInput;
import java.io.ObjectInputValidation;
import java.io.StreamCorruptedException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

public class FastObjectInput
implements ObjectInput {
    private static final ThreadLocal<FastObjectInput> threadFastObjectInput = new ThreadLocal();
    private final ObjectInput in;
    private int wrapCount;
    private final List<Class<?>> classesById = new ArrayList();
    private final List<Long> serialVersionUIDsById = new ArrayList<Long>();
    private int nextClassId;
    private Class<?> lastClass;
    private long lastSerialVersionUID;
    private final List<String> stringsById = new ArrayList<String>();
    private int nextStringId;
    private String lastString;

    public static FastObjectInput wrap(ObjectInput in) throws IOException {
        FastObjectInput fastIn;
        if (in instanceof FastObjectInput) {
            fastIn = (FastObjectInput)in;
        } else {
            fastIn = threadFastObjectInput.get();
            if (fastIn == null) {
                fastIn = new FastObjectInput(in);
                threadFastObjectInput.set(fastIn);
            } else if (in != fastIn.in) {
                throw new IOException("ObjectInput changed unexpectedly");
            }
        }
        fastIn.incrementWrapCount();
        return fastIn;
    }

    private FastObjectInput(ObjectInput in) {
        this.in = in;
    }

    private void incrementWrapCount() throws IOException {
        if (this.wrapCount == Integer.MAX_VALUE) {
            throw new IOException("Maximum wrap count reached.");
        }
        ++this.wrapCount;
    }

    public void unwrap() throws IllegalStateException {
        assert (this.wrapCount >= 0);
        if (this.wrapCount == 0) {
            throw new IllegalStateException("Not wrapped");
        }
        --this.wrapCount;
        if (this.wrapCount == 0) {
            threadFastObjectInput.remove();
        }
    }

    @Override
    public Object readObject() throws IOException, ClassNotFoundException {
        int code = this.in.read();
        switch (code) {
            case 0: {
                return null;
            }
            case 1: {
                return this.in.readObject();
            }
            case -1: {
                throw new EOFException();
            }
        }
        return this.readFastObject(code);
    }

    protected FastExternalizable readFastObject() throws IOException, ClassNotFoundException {
        int code = this.in.read();
        switch (code) {
            case 0: {
                return null;
            }
            case 1: {
                return (FastExternalizable)this.in.readObject();
            }
            case -1: {
                throw new EOFException();
            }
        }
        return this.readFastObject(code);
    }

    private FastExternalizable readFastObject(int code) throws IOException, ClassNotFoundException {
        assert (code >= 2);
        switch (code) {
            case 3: {
                if (this.lastClass != null) break;
                throw new StreamCorruptedException("lastClass is null");
            }
            case 2: {
                this.lastClass = Class.forName(this.in.readUTF());
                this.classesById.add(this.lastClass);
                this.lastSerialVersionUID = this.in.readLong();
                this.serialVersionUIDsById.add(this.lastSerialVersionUID);
                ++this.nextClassId;
                break;
            }
            case 4: {
                int offset = this.in.readShort() & 0xFFFF;
                int classId = offset + 250;
                if (classId >= this.nextClassId) {
                    throw new StreamCorruptedException("Class ID not already in steam: " + classId);
                }
                this.lastClass = this.classesById.get(classId);
                this.lastSerialVersionUID = this.serialVersionUIDsById.get(classId);
                break;
            }
            case 5: {
                int classId = this.in.readInt();
                if (classId >= this.nextClassId) {
                    throw new StreamCorruptedException("Class ID not already in steam: " + classId);
                }
                this.lastClass = this.classesById.get(classId);
                this.lastSerialVersionUID = this.serialVersionUIDsById.get(classId);
                break;
            }
            default: {
                assert (code > 5);
                int classId = code - 6;
                if (classId >= this.nextClassId) {
                    throw new StreamCorruptedException("Class ID not already in steam: " + classId);
                }
                this.lastClass = this.classesById.get(classId);
                this.lastSerialVersionUID = this.serialVersionUIDsById.get(classId);
            }
        }
        try {
            FastExternalizable obj = (FastExternalizable)this.lastClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            long actualSerialVersionUID = obj.getSerialVersionUID();
            if (this.lastSerialVersionUID != actualSerialVersionUID) {
                throw new InvalidClassException(this.lastClass.getName(), "Mismatched serialVersionUID: expected " + this.lastSerialVersionUID + ", got " + actualSerialVersionUID);
            }
            obj.readExternal(this);
            if (obj instanceof ObjectInputValidation) {
                ((ObjectInputValidation)((Object)obj)).validateObject();
            }
            return obj;
        }
        catch (NoSuchMethodException exc) {
            InvalidClassException newExc = new InvalidClassException("NoSuchMethodException");
            newExc.initCause(exc);
            throw newExc;
        }
        catch (InstantiationException exc) {
            InvalidClassException newExc = new InvalidClassException("InstantiationException");
            newExc.initCause(exc);
            throw newExc;
        }
        catch (IllegalAccessException exc) {
            InvalidClassException newExc = new InvalidClassException("IllegalAccessException");
            newExc.initCause(exc);
            throw newExc;
        }
        catch (InvocationTargetException exc) {
            InvalidClassException newExc = new InvalidClassException("InvocationTargetException");
            newExc.initCause(exc);
            throw newExc;
        }
    }

    public String readFastUTF() throws IOException {
        int code = this.in.read();
        switch (code) {
            case 0: {
                return null;
            }
            case 1: {
                throw new IOException("Unexpected code: " + code);
            }
            case -1: {
                throw new EOFException();
            }
            case 3: {
                if (this.lastString == null) {
                    throw new StreamCorruptedException("lastString is null");
                }
                return this.lastString;
            }
            case 2: {
                this.lastString = this.in.readUTF();
                this.stringsById.add(this.lastString);
                ++this.nextStringId;
                return this.lastString;
            }
            case 4: {
                int offset = this.in.readShort() & 0xFFFF;
                int stringId = offset + 250;
                if (stringId >= this.nextStringId) {
                    throw new StreamCorruptedException("String ID not already in steam: " + stringId);
                }
                this.lastString = this.stringsById.get(stringId);
                return this.lastString;
            }
            case 5: {
                int stringId = this.in.readInt();
                if (stringId >= this.nextStringId) {
                    throw new StreamCorruptedException("String ID not already in steam: " + stringId);
                }
                this.lastString = this.stringsById.get(stringId);
                return this.lastString;
            }
        }
        assert (code > 5);
        int stringId = code - 6;
        if (stringId >= this.nextStringId) {
            throw new StreamCorruptedException("String ID not already in steam: " + stringId);
        }
        this.lastString = this.stringsById.get(stringId);
        return this.lastString;
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.in.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.in.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.in.readFully(b);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.in.readFully(b, off, len);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this.in.skipBytes(n);
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.in.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        return this.in.readByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.in.readUnsignedByte();
    }

    @Override
    public short readShort() throws IOException {
        return this.in.readShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.in.readUnsignedShort();
    }

    @Override
    public char readChar() throws IOException {
        return this.in.readChar();
    }

    @Override
    public int readInt() throws IOException {
        return this.in.readInt();
    }

    @Override
    public long readLong() throws IOException {
        return this.in.readLong();
    }

    @Override
    public float readFloat() throws IOException {
        return this.in.readFloat();
    }

    @Override
    public double readDouble() throws IOException {
        return this.in.readDouble();
    }

    @Override
    public String readLine() throws IOException {
        return this.in.readLine();
    }

    @Override
    public String readUTF() throws IOException {
        return this.in.readUTF();
    }
}

