/*
 * Decompiled with CFR 0.152.
 */
package com.aoapps.lang.io;

import com.aoapps.lang.io.FastExternalizable;
import java.io.IOException;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;

public class FastObjectOutput
implements ObjectOutput {
    private static final ThreadLocal<FastObjectOutput> threadFastObjectOutput = new ThreadLocal();
    static final int NULL = 0;
    static final int STANDARD = 1;
    static final int FAST_NEW = 2;
    static final int FAST_SAME = 3;
    static final int FAST_SEEN_SHORT = 4;
    static final int FAST_SEEN_INT = 5;
    private final ObjectOutput out;
    private int wrapCount;
    private final Map<Class<?>, Integer> classesMap = new HashMap();
    private int nextClassId;
    private Class<?> lastClass;
    private final Map<String, Integer> stringsMap = new HashMap<String, Integer>();
    private int nextStringId;
    private String lastString;

    public static FastObjectOutput wrap(ObjectOutput out) throws IOException {
        FastObjectOutput fastOut;
        if (out instanceof FastObjectOutput) {
            fastOut = (FastObjectOutput)out;
        } else {
            fastOut = threadFastObjectOutput.get();
            if (fastOut == null) {
                fastOut = new FastObjectOutput(out);
                threadFastObjectOutput.set(fastOut);
            } else if (out != fastOut.out) {
                throw new IOException("ObjectOutput changed unexpectedly");
            }
        }
        fastOut.incrementWrapCount();
        return fastOut;
    }

    private FastObjectOutput(ObjectOutput out) {
        this.out = out;
    }

    private void incrementWrapCount() throws IOException {
        if (this.wrapCount == Integer.MAX_VALUE) {
            throw new IOException("Maximum wrap count reached.");
        }
        ++this.wrapCount;
    }

    public void unwrap() throws IllegalStateException {
        assert (this.wrapCount >= 0);
        if (this.wrapCount == 0) {
            throw new IllegalStateException("Not wrapped");
        }
        --this.wrapCount;
        if (this.wrapCount == 0) {
            threadFastObjectOutput.remove();
        }
    }

    @Override
    public void writeObject(Object obj) throws IOException {
        if (obj == null) {
            this.out.write(0);
        } else if (obj instanceof FastExternalizable) {
            this.writeFastObject((FastExternalizable)obj);
        } else {
            this.out.write(1);
            this.out.writeObject(obj);
        }
    }

    protected void writeFastObject(FastExternalizable obj) throws IOException {
        if (obj == null) {
            this.out.write(0);
        } else {
            Class<?> clazz = obj.getClass();
            if (clazz == this.lastClass) {
                this.out.write(3);
            } else {
                Integer classIdObj = this.classesMap.get(clazz);
                if (classIdObj == null) {
                    this.classesMap.put(clazz, this.nextClassId++);
                    this.out.write(2);
                    this.out.writeUTF(clazz.getName());
                    this.out.writeLong(obj.getSerialVersionUID());
                } else {
                    int classId = classIdObj;
                    if (classId < 250) {
                        int code = classId + 6;
                        assert (code > 5);
                        assert (code <= 255);
                        this.out.write(code);
                    } else if (classId <= 65786) {
                        this.out.write(4);
                        int offset = classId - 250;
                        assert (offset >= 0);
                        assert (offset <= 65535);
                        this.out.writeShort(offset);
                    } else {
                        this.out.write(5);
                        assert (classId > 65786);
                        this.out.writeInt(classId);
                    }
                }
                this.lastClass = clazz;
            }
            obj.writeExternal(this);
        }
    }

    public void writeFastUTF(String value) throws IOException {
        if (value == null) {
            this.out.write(0);
        } else if (value.equals(this.lastString)) {
            this.out.write(3);
        } else {
            Integer stringIdObj = this.stringsMap.get(value);
            if (stringIdObj == null) {
                this.stringsMap.put(value, this.nextStringId++);
                this.out.write(2);
                this.out.writeUTF(value);
            } else {
                int stringId = stringIdObj;
                if (stringId < 250) {
                    int code = stringId + 6;
                    assert (code > 5);
                    assert (code <= 255);
                    this.out.write(code);
                } else if (stringId <= 65786) {
                    this.out.write(4);
                    int offset = stringId - 250;
                    assert (offset >= 0);
                    assert (offset <= 65535);
                    this.out.writeShort(offset);
                } else {
                    this.out.write(5);
                    assert (stringId > 65786);
                    this.out.writeInt(stringId);
                }
            }
            this.lastString = value;
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.out.writeBoolean(v);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.out.writeByte(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.out.writeShort(v);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.out.writeChar(v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.out.writeInt(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.out.writeLong(v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.out.writeFloat(v);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.out.writeDouble(v);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this.out.writeBytes(s);
    }

    @Override
    public void writeChars(String s) throws IOException {
        this.out.writeChars(s);
    }

    @Override
    public void writeUTF(String s) throws IOException {
        this.out.writeUTF(s);
    }
}

