/*
 * Decompiled with CFR 0.152.
 */
package com.aoapps.lang.io;

import com.aoapps.lang.EmptyArrays;
import com.aoapps.lang.Throwables;
import com.aoapps.lang.exception.LocalizedException;
import com.aoapps.lang.i18n.Resources;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;

public class LocalizedUnsupportedEncodingException
extends UnsupportedEncodingException
implements LocalizedException {
    private static final long serialVersionUID = 3L;
    protected final Resources resources;
    protected final String key;
    protected final Serializable[] args;

    public LocalizedUnsupportedEncodingException(Resources resources, String key) {
        super(resources.getMessage(key));
        this.resources = resources;
        this.key = key;
        this.args = EmptyArrays.EMPTY_SERIALIZABLE_ARRAY;
    }

    public LocalizedUnsupportedEncodingException(Resources resources, String key, Serializable ... args) {
        super(resources.getMessage(key, args));
        this.resources = resources;
        this.key = key;
        this.args = args;
    }

    public LocalizedUnsupportedEncodingException(Throwable cause, Resources resources, String key) {
        super(resources.getMessage(key));
        this.resources = resources;
        this.key = key;
        this.args = EmptyArrays.EMPTY_SERIALIZABLE_ARRAY;
        if (cause != null) {
            this.initCause(cause);
        }
    }

    public LocalizedUnsupportedEncodingException(Throwable cause, Resources resources, String key, Serializable ... args) {
        super(resources.getMessage(key, args));
        this.resources = resources;
        this.key = key;
        this.args = args;
        if (cause != null) {
            this.initCause(cause);
        }
    }

    @Override
    public String getLocalizedMessage() {
        return this.resources.getMessage(this.key, this.args);
    }

    @Override
    public final Resources getResources() {
        return this.resources;
    }

    @Override
    public final String getKey() {
        return this.key;
    }

    @Override
    public final Serializable[] getArgs() {
        return this.args;
    }

    static {
        Throwables.registerSurrogateFactory(LocalizedUnsupportedEncodingException.class, (template, cause) -> new LocalizedUnsupportedEncodingException(cause, template.resources, template.key, template.args));
    }
}

