/*
 * Decompiled with CFR 0.152.
 */
package com.aoapps.lang.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class SniffInputStream
extends InputStream {
    private final InputStream in;
    private final OutputStream out;

    public SniffInputStream(InputStream in, OutputStream out) {
        this.in = in;
        this.out = out;
    }

    @Override
    public int read() throws IOException {
        int b = this.in.read();
        if (b != -1) {
            this.out.write(b);
        }
        return b;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int numBytes = this.in.read(b);
        if (numBytes > 0) {
            this.out.write(b, 0, numBytes);
        }
        return numBytes;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int numBytes = this.in.read(b, off, len);
        if (numBytes > 0) {
            this.out.write(b, off, numBytes);
        }
        return numBytes;
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.out.flush();
    }
}

