/*
 * Decompiled with CFR 0.152.
 */
package com.aoapps.lang.text;

import com.aoapps.lang.i18n.ThreadLocale;
import com.aoapps.lang.text.UnmodifiableMessageFormat;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class MessageFormatFactory {
    private static final ConcurrentMap<Locale, ConcurrentMap<String, UnmodifiableMessageFormat>> cache = new ConcurrentHashMap<Locale, ConcurrentMap<String, UnmodifiableMessageFormat>>();

    private MessageFormatFactory() {
        throw new AssertionError();
    }

    public static UnmodifiableMessageFormat getMessageFormat(String pattern) {
        return MessageFormatFactory.getMessageFormat(pattern, ThreadLocale.get());
    }

    public static UnmodifiableMessageFormat getMessageFormat(String pattern, Locale locale) {
        UnmodifiableMessageFormat existing;
        UnmodifiableMessageFormat messageFormat;
        ConcurrentMap existing2;
        ConcurrentMap<String, UnmodifiableMessageFormat> localeCache = (ConcurrentHashMap)cache.get(locale);
        if (localeCache == null && (existing2 = (ConcurrentMap)cache.putIfAbsent(locale, localeCache = new ConcurrentHashMap())) != null) {
            localeCache = existing2;
        }
        if ((messageFormat = (UnmodifiableMessageFormat)localeCache.get(pattern)) == null && (existing = localeCache.putIfAbsent(pattern, messageFormat = new UnmodifiableMessageFormat(pattern, locale))) != null) {
            messageFormat = existing;
        }
        return messageFormat;
    }
}

