/*
 * Decompiled with CFR 0.152.
 */
package com.aoapps.lang.time;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;

@Deprecated
public class Instant
implements Comparable<Instant>,
Serializable {
    static final int NANOS_PER_SECOND = 1000000000;
    public static final Instant EPOCH = new Instant(0L, 0);
    private static final long serialVersionUID = 2L;
    final long epochSecond;
    final int nano;

    public static Instant valueOf(String s) {
        if (s == null) {
            return null;
        }
        int dotPos = s.indexOf(46);
        if (dotPos == -1) {
            throw new IllegalArgumentException("Period (.) not found: " + s);
        }
        return new Instant(Long.parseLong(s.substring(0, dotPos)), Integer.parseInt(s.substring(dotPos + 1)));
    }

    public Instant(long epochSecond, int nano) {
        this.epochSecond = epochSecond;
        this.nano = nano;
        this.validate();
    }

    private void validate() throws IllegalArgumentException {
        if (this.nano < 0 || this.nano >= 1000000000) {
            throw new IllegalArgumentException("nanoseconds out of range 0-999999999");
        }
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        try {
            this.validate();
        }
        catch (IllegalArgumentException err) {
            InvalidObjectException newErr = new InvalidObjectException(err.getMessage());
            newErr.initCause(err);
            throw newErr;
        }
    }

    protected Object readResolve() {
        if (this.epochSecond == 0L && this.nano == 0) {
            return EPOCH;
        }
        return this;
    }

    static String toString(long epochSecond, int nano) {
        StringBuilder sb = new StringBuilder(30);
        sb.append(epochSecond).append('.');
        if (nano < 100000000) {
            sb.append('0');
            if (nano < 10000000) {
                sb.append('0');
                if (nano < 1000000) {
                    sb.append('0');
                    if (nano < 100000) {
                        sb.append('0');
                        if (nano < 10000) {
                            sb.append('0');
                            if (nano < 1000) {
                                sb.append('0');
                                if (nano < 100) {
                                    sb.append('0');
                                    if (nano < 10) {
                                        sb.append('0');
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        sb.append(nano);
        return sb.toString();
    }

    public String toString() {
        return Instant.toString(this.epochSecond, this.nano);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Instant)) {
            return false;
        }
        return this.equals((Instant)obj);
    }

    public boolean equals(Instant other) {
        return other != null && this.epochSecond == other.epochSecond && this.nano == other.nano;
    }

    public int hashCode() {
        return Long.hashCode(this.epochSecond) ^ this.nano;
    }

    @Override
    public int compareTo(Instant other) {
        if (this.epochSecond < other.epochSecond) {
            return -1;
        }
        if (this.epochSecond > other.epochSecond) {
            return 1;
        }
        if (this.nano < other.nano) {
            return -1;
        }
        if (this.nano > other.nano) {
            return 1;
        }
        return 0;
    }

    public long getEpochSecond() {
        return this.epochSecond;
    }

    public int getNano() {
        return this.nano;
    }

    public Instant plusNanos(long nanosToAdd) {
        if (nanosToAdd == 0L) {
            return this;
        }
        long newSeconds = this.epochSecond + nanosToAdd / 1000000000L;
        int newNanos = this.nano + (int)(nanosToAdd % 1000000000L);
        if (newNanos >= 1000000000) {
            ++newSeconds;
            newNanos -= 1000000000;
        } else if (newNanos < 0) {
            --newSeconds;
            newNanos += 1000000000;
        }
        return new Instant(newSeconds, newNanos);
    }
}

