/*
 * Decompiled with CFR 0.152.
 */
package com.aoapps.lang.util;

import java.lang.ref.SoftReference;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.concurrent.atomic.AtomicLong;

public final class BufferManager {
    public static final int BUFFER_SIZE = 4096;
    private static final ThreadLocal<Deque<SoftReference<byte[]>>> bytes = ThreadLocal.withInitial(ArrayDeque::new);
    private static final ThreadLocal<Deque<SoftReference<char[]>>> chars = ThreadLocal.withInitial(ArrayDeque::new);
    private static final AtomicLong bytesCreates = new AtomicLong();
    private static final AtomicLong bytesUses = new AtomicLong();
    private static final AtomicLong bytesZeroFills = new AtomicLong();
    private static final AtomicLong bytesCollected = new AtomicLong();
    private static final AtomicLong charsCreates = new AtomicLong();
    private static final AtomicLong charsUses = new AtomicLong();
    private static final AtomicLong charsZeroFills = new AtomicLong();
    private static final AtomicLong charsCollected = new AtomicLong();

    private BufferManager() {
        throw new AssertionError();
    }

    public static byte[] getBytes() {
        SoftReference<byte[]> bufferRef;
        bytesUses.getAndIncrement();
        Deque<SoftReference<byte[]>> myBytes = bytes.get();
        while ((bufferRef = myBytes.poll()) != null) {
            byte[] buffer = bufferRef.get();
            if (buffer != null) {
                return buffer;
            }
            bytesCollected.getAndIncrement();
        }
        bytesCreates.getAndIncrement();
        return new byte[4096];
    }

    public static char[] getChars() {
        SoftReference<char[]> bufferRef;
        charsUses.getAndIncrement();
        Deque<SoftReference<char[]>> myChars = chars.get();
        while ((bufferRef = myChars.poll()) != null) {
            char[] buffer = bufferRef.get();
            if (buffer != null) {
                return buffer;
            }
            charsCollected.getAndIncrement();
        }
        charsCreates.getAndIncrement();
        return new char[4096];
    }

    @Deprecated
    public static void release(byte[] buffer) {
        BufferManager.release(buffer, true);
    }

    public static void release(byte[] buffer, boolean zeroFill) {
        Deque<SoftReference<byte[]>> myBytes = bytes.get();
        if (buffer.length != 4096) {
            throw new IllegalArgumentException();
        }
        assert (!BufferManager.inQueue(myBytes, buffer));
        if (zeroFill) {
            bytesZeroFills.getAndIncrement();
            Arrays.fill(buffer, 0, 4096, (byte)0);
        }
        myBytes.add(new SoftReference<byte[]>(buffer));
    }

    private static boolean inQueue(Iterable<SoftReference<byte[]>> myBytes, byte[] buffer) {
        for (SoftReference<byte[]> inQueue : myBytes) {
            if (inQueue.get() != buffer) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static void release(char[] buffer) {
        BufferManager.release(buffer, true);
    }

    public static void release(char[] buffer, boolean zeroFill) {
        Deque<SoftReference<char[]>> myChars = chars.get();
        if (buffer.length != 4096) {
            throw new IllegalArgumentException();
        }
        assert (!BufferManager.inQueue(myChars, buffer));
        if (zeroFill) {
            charsZeroFills.getAndIncrement();
            Arrays.fill(buffer, 0, 4096, '\u0000');
        }
        myChars.add(new SoftReference<char[]>(buffer));
    }

    private static boolean inQueue(Iterable<SoftReference<char[]>> myChars, char[] buffer) {
        for (SoftReference<char[]> inQueue : myChars) {
            if (inQueue.get() != buffer) continue;
            return true;
        }
        return false;
    }

    public static long getByteBufferCreates() {
        return bytesCreates.get();
    }

    public static long getByteBufferUses() {
        return bytesUses.get();
    }

    public static long getByteBufferZeroFills() {
        return bytesZeroFills.get();
    }

    public static long getByteBuffersCollected() {
        return bytesCollected.get();
    }

    public static long getCharBufferCreates() {
        return charsCreates.get();
    }

    public static long getCharBufferUses() {
        return charsUses.get();
    }

    public static long getCharBufferZeroFills() {
        return charsZeroFills.get();
    }

    public static long getCharBuffersCollected() {
        return charsCollected.get();
    }
}

