/*
 * Decompiled with CFR 0.152.
 */
package com.aoapps.lang.util;

import com.aoapps.lang.util.UnmodifiableCalendar;
import java.io.IOException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public final class CalendarUtils {
    private CalendarUtils() {
        throw new AssertionError();
    }

    public static String formatDate(Calendar cal) {
        if (cal == null) {
            return null;
        }
        try {
            StringBuilder result = new StringBuilder("YYYY-MM-DD".length());
            CalendarUtils.formatDate(cal, result);
            return result.toString();
        }
        catch (IOException e) {
            throw new AssertionError("IOException should never occur on StringBuilder", e);
        }
    }

    public static void formatDate(Calendar cal, Appendable out) throws IOException {
        if (cal != null) {
            Calendar gcal;
            if (UnmodifiableCalendar.isInstanceOf(cal, GregorianCalendar.class)) {
                gcal = cal;
            } else {
                gcal = new GregorianCalendar(cal.getTimeZone());
                gcal.setTimeInMillis(cal.getTimeInMillis());
            }
            out.append(Integer.toString(gcal.get(1)));
            out.append('-');
            int month = gcal.get(2) + 1;
            if (month < 10) {
                out.append('0');
            }
            out.append(Integer.toString(month));
            out.append('-');
            int day = gcal.get(5);
            if (day < 10) {
                out.append('0');
            }
            out.append(Integer.toString(day));
        }
    }

    public static GregorianCalendar parseDate(String yyyy_mm_dd, TimeZone timeZone) throws IllegalArgumentException {
        if (yyyy_mm_dd == null) {
            return null;
        }
        int pos1 = (yyyy_mm_dd = yyyy_mm_dd.trim()).indexOf(45, 1);
        if (pos1 == -1) {
            throw new IllegalArgumentException("Invalid date: " + yyyy_mm_dd);
        }
        int pos2 = yyyy_mm_dd.indexOf(45, pos1 + 1);
        if (pos2 == -1) {
            throw new IllegalArgumentException("Invalid date: " + yyyy_mm_dd);
        }
        int year = Integer.parseInt(yyyy_mm_dd.substring(0, pos1).trim());
        int month = Integer.parseInt(yyyy_mm_dd.substring(pos1 + 1, pos2).trim());
        int day = Integer.parseInt(yyyy_mm_dd.substring(pos2 + 1).trim());
        GregorianCalendar gcal = timeZone == null ? new GregorianCalendar() : new GregorianCalendar(timeZone);
        gcal.set(1, year);
        if (month < 1 || month > 12) {
            throw new IllegalArgumentException("Invalid month: " + yyyy_mm_dd);
        }
        gcal.set(2, month - 1);
        gcal.set(5, 1);
        if (day < 1 || day > gcal.getActualMaximum(5)) {
            throw new IllegalArgumentException("Invalid day of month: " + yyyy_mm_dd);
        }
        gcal.set(5, day);
        gcal.set(11, 0);
        gcal.set(12, 0);
        gcal.set(13, 0);
        gcal.set(14, 0);
        return gcal;
    }

    public static GregorianCalendar parseDate(String yyyy_mm_dd) throws IllegalArgumentException {
        return CalendarUtils.parseDate(yyyy_mm_dd, null);
    }

    public static String formatTime(Calendar cal) {
        if (cal == null) {
            return null;
        }
        try {
            StringBuilder result = new StringBuilder("HH:MM:SS".length());
            CalendarUtils.formatTime(cal, result);
            return result.toString();
        }
        catch (IOException e) {
            throw new AssertionError("IOException should never occur on StringBuilder", e);
        }
    }

    public static void formatTime(Calendar cal, Appendable out) throws IOException {
        if (cal != null) {
            Calendar gcal;
            if (UnmodifiableCalendar.isInstanceOf(cal, GregorianCalendar.class)) {
                gcal = cal;
            } else {
                gcal = new GregorianCalendar(cal.getTimeZone());
                gcal.setTimeInMillis(cal.getTimeInMillis());
            }
            int hour = gcal.get(11);
            if (hour < 10) {
                out.append('0');
            }
            out.append(Integer.toString(hour));
            out.append(':');
            int minute = gcal.get(12);
            if (minute < 10) {
                out.append('0');
            }
            out.append(Integer.toString(minute));
            out.append(':');
            int second = gcal.get(13);
            if (second < 10) {
                out.append('0');
            }
            out.append(Integer.toString(second));
        }
    }

    public static String formatDateTime(Calendar cal) {
        if (cal == null) {
            return null;
        }
        try {
            StringBuilder result = new StringBuilder("YYYY-MM-DD HH:MM:SS".length());
            CalendarUtils.formatDateTime(cal, result);
            return result.toString();
        }
        catch (IOException e) {
            throw new AssertionError("IOException should never occur on StringBuilder", e);
        }
    }

    public static void formatDateTime(Calendar cal, Appendable out) throws IOException {
        if (cal != null) {
            CalendarUtils.formatDate(cal, out);
            out.append(' ');
            CalendarUtils.formatTime(cal, out);
        }
    }

    public static <T> T parseDateTime(String dateTime, TimeZone timeZone, DateTimeProducer<T> producer) throws IllegalArgumentException {
        int hour;
        int minute;
        int second;
        int nanos;
        int day;
        if (dateTime == null) {
            return null;
        }
        int pos1 = (dateTime = dateTime.trim()).indexOf(45, 1);
        if (pos1 == -1) {
            throw new IllegalArgumentException("Invalid datetime: " + dateTime);
        }
        int pos2 = dateTime.indexOf(45, pos1 + 1);
        if (pos2 == -1) {
            throw new IllegalArgumentException("Invalid datetime: " + dateTime);
        }
        int year = Integer.parseInt(dateTime.substring(0, pos1).trim());
        int month = Integer.parseInt(dateTime.substring(pos1 + 1, pos2).trim());
        int pos3 = dateTime.indexOf(32, pos2 + 1);
        if (pos3 == -1) {
            day = Integer.parseInt(dateTime.substring(pos2 + 1).trim());
            nanos = 0;
            second = 0;
            minute = 0;
            hour = 0;
        } else {
            day = Integer.parseInt(dateTime.substring(pos2 + 1, pos3).trim());
            int pos4 = dateTime.indexOf(58, pos3 + 1);
            if (pos4 == -1) {
                throw new IllegalArgumentException("Invalid datetime: " + dateTime);
            }
            hour = Integer.parseInt(dateTime.substring(pos3 + 1, pos4).trim());
            int pos5 = dateTime.indexOf(58, pos4 + 1);
            if (pos5 == -1) {
                minute = Integer.parseInt(dateTime.substring(pos4 + 1).trim());
                nanos = 0;
                second = 0;
            } else {
                minute = Integer.parseInt(dateTime.substring(pos4 + 1, pos5).trim());
                int pos6 = dateTime.indexOf(46, pos5 + 1);
                if (pos6 == -1) {
                    String secondString = dateTime.substring(pos5 + 1).trim();
                    second = secondString.isEmpty() ? 0 : Integer.parseInt(secondString);
                    nanos = 0;
                } else {
                    second = Integer.parseInt(dateTime.substring(pos5 + 1, pos6).trim());
                    String nanosString = dateTime.substring(pos6 + 1).trim();
                    int len = nanosString.length();
                    nanos = len == 0 ? 0 : (len == 1 ? 100000000 * Integer.parseInt(nanosString) : (len == 2 ? 10000000 * Integer.parseInt(nanosString) : (len == 3 ? 1000000 * Integer.parseInt(nanosString) : (len == 4 ? 100000 * Integer.parseInt(nanosString) : (len == 5 ? 10000 * Integer.parseInt(nanosString) : (len == 6 ? 1000 * Integer.parseInt(nanosString) : (len == 7 ? 100 * Integer.parseInt(nanosString) : (len == 8 ? 10 * Integer.parseInt(nanosString) : Integer.parseInt(nanosString)))))))));
                }
            }
        }
        GregorianCalendar gcal = timeZone == null ? new GregorianCalendar() : new GregorianCalendar(timeZone);
        gcal.set(1, year);
        if (month < 1 || month > 12) {
            throw new IllegalArgumentException("Invalid month: " + dateTime);
        }
        gcal.set(2, month - 1);
        gcal.set(5, 1);
        if (day < 1 || day > gcal.getActualMaximum(5)) {
            throw new IllegalArgumentException("Invalid day of month: " + dateTime);
        }
        if (hour < 0 || hour > 23) {
            throw new IllegalArgumentException("Invalid hour: " + dateTime);
        }
        if (minute < 0 || minute > 59) {
            throw new IllegalArgumentException("Invalid minute: " + dateTime);
        }
        if (second < 0 || second > 59) {
            throw new IllegalArgumentException("Invalid second: " + dateTime);
        }
        if (nanos < 0 || nanos > 999999999) {
            throw new IllegalArgumentException("Invalid nanos: " + dateTime);
        }
        gcal.set(5, day);
        gcal.set(11, hour);
        gcal.set(12, minute);
        gcal.set(13, second);
        gcal.set(14, nanos / 1000000);
        return producer.createDateTime(gcal, nanos);
    }

    public static GregorianCalendar parseDateTime(String dateTime, TimeZone timeZone) throws IllegalArgumentException {
        return CalendarUtils.parseDateTime(dateTime, timeZone, (gcal, nanos) -> {
            if (nanos % 1000000 != 0) {
                throw new IllegalArgumentException("Only millisecond precision supported: nanos: " + nanos);
            }
            return gcal;
        });
    }

    public static GregorianCalendar parseDateTime(String dateTime) throws IllegalArgumentException {
        return CalendarUtils.parseDateTime(dateTime, null);
    }

    public static GregorianCalendar getToday(TimeZone timeZone) {
        GregorianCalendar gcal = timeZone == null ? new GregorianCalendar() : new GregorianCalendar(timeZone);
        gcal.set(11, 0);
        gcal.set(12, 0);
        gcal.set(13, 0);
        gcal.set(14, 0);
        return gcal;
    }

    public static GregorianCalendar getToday() {
        return CalendarUtils.getToday(null);
    }

    @FunctionalInterface
    public static interface DateTimeProducer<T> {
        public T createDateTime(GregorianCalendar var1, int var2);
    }
}

