/*
 * Decompiled with CFR 0.152.
 */
package com.aoapps.lang.util;

import com.aoapps.lang.i18n.Resources;
import com.aoapps.lang.io.LocalizedIOException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Properties;
import java.util.ResourceBundle;

public final class PropertiesUtils {
    public static final Resources RESOURCES = Resources.getResources(ResourceBundle::getBundle, PropertiesUtils.class);

    private PropertiesUtils() {
        throw new AssertionError();
    }

    public static Properties loadFromFile(File file) throws IOException {
        Properties props = new Properties();
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
            props.load(in);
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadFromResource(Class<?> clazz, String resource) throws IOException {
        Properties props = new Properties();
        InputStream in = clazz.getResourceAsStream(resource);
        if (in == null && resource.startsWith("/")) {
            String name = resource;
            while ((name = name.substring(1)).startsWith("/")) {
            }
            ClassLoader classloader = Thread.currentThread().getContextClassLoader();
            InputStream inputStream = in = classloader != null ? classloader.getResourceAsStream(name) : ClassLoader.getSystemResourceAsStream(name);
        }
        if (in == null) {
            throw new LocalizedIOException(RESOURCES, "readProperties.resourceNotFound", new Serializable[]{resource});
        }
        try {
            props.load(in);
        }
        finally {
            in.close();
        }
        return props;
    }
}

