/*
 * Decompiled with CFR 0.152.
 */
package com.aoapps.lang.zip;

import com.aoapps.lang.exception.NotImplementedException;
import com.aoapps.lang.io.FileUtils;
import com.aoapps.lang.io.IoUtils;
import com.aoapps.lang.zip.ZipEntryFilter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public final class ZipUtils {
    private static final Comparator<File> reverseFileComparator = (f1, f2) -> {
        try {
            String path1 = f1.getCanonicalPath();
            String path2 = f2.getCanonicalPath();
            return path2.compareTo(path1);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    };

    private ZipUtils() {
        throw new AssertionError();
    }

    public static long getZipEntryTime(ZipEntry entry) {
        long time = entry.getTime();
        return time == -1L ? -1L : time + (long)TimeZone.getDefault().getOffset(time);
    }

    public static void setZipEntryTime(ZipEntry entry, long time) {
        entry.setTime(time - (long)TimeZone.getDefault().getOffset(time));
    }

    public static void createZipFile(File sourceDirectory, File zipFile) throws IOException {
        try (FileOutputStream out = new FileOutputStream(zipFile);){
            ZipUtils.createZipFile(sourceDirectory, out);
        }
    }

    public static void createZipFile(File sourceDirectory, OutputStream out) throws IOException {
        ZipOutputStream zipOut = new ZipOutputStream(out);
        try {
            ZipUtils.createZipFile(sourceDirectory, zipOut);
        }
        finally {
            zipOut.finish();
        }
    }

    public static void createZipFile(File sourceDirectory, ZipOutputStream zipOut) throws IOException {
        File[] list = sourceDirectory.listFiles();
        if (list != null) {
            for (File file : list) {
                ZipUtils.createZipFile(file, zipOut, "");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createZipFile(File file, ZipOutputStream zipOut, String path) throws IOException {
        block5: {
            String newPath;
            block4: {
                String filename = file.getName();
                String string = newPath = path.isEmpty() ? filename : path + '/' + filename;
                if (!file.isDirectory()) break block4;
                ZipEntry zipEntry = new ZipEntry(newPath + '/');
                ZipUtils.setZipEntryTime(zipEntry, file.lastModified());
                zipOut.putNextEntry(zipEntry);
                zipOut.closeEntry();
                File[] list = file.listFiles();
                if (list == null) break block5;
                for (File child : list) {
                    ZipUtils.createZipFile(child, zipOut, newPath);
                }
                break block5;
            }
            ZipEntry zipEntry = new ZipEntry(newPath);
            ZipUtils.setZipEntryTime(zipEntry, file.lastModified());
            zipOut.putNextEntry(zipEntry);
            try {
                FileUtils.copy(file, zipOut);
            }
            finally {
                zipOut.closeEntry();
            }
        }
    }

    public static void unzip(File sourceFile, File destination) throws IOException {
        ZipUtils.unzip(sourceFile, "", destination, null);
    }

    public static void unzip(File sourceFile, String sourcePrefix, File destination, ZipEntryFilter filter) throws IOException {
        if (!destination.isDirectory()) {
            throw new IOException("Not a directory: " + destination.getPath());
        }
        if (!sourcePrefix.isEmpty() && !sourcePrefix.endsWith("/")) {
            sourcePrefix = sourcePrefix + "/";
        }
        try (ZipFile zipFile = new ZipFile(sourceFile);){
            TreeMap<File, Long> directoryModifyTimes = new TreeMap<File, Long>(reverseFileComparator);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.startsWith(sourcePrefix) || (name = name.substring(sourcePrefix.length())).isEmpty() || filter != null && !filter.accept(entry)) continue;
                long entryTime = ZipUtils.getZipEntryTime(entry);
                if (entry.isDirectory()) {
                    File directory = new File(destination, name = name.substring(0, name.length() - 1));
                    if (!directory.exists()) {
                        Files.createDirectories(directory.toPath(), new FileAttribute[0]);
                    }
                    if (entryTime == -1L) continue;
                    directoryModifyTimes.put(directory, entryTime);
                    continue;
                }
                File file = new File(destination, name);
                File directory = file.getParentFile();
                if (!directory.exists()) {
                    Files.createDirectories(directory.toPath(), new FileAttribute[0]);
                }
                if (file.exists()) {
                    throw new IOException("File exists: " + file.getPath());
                }
                InputStream in = zipFile.getInputStream(entry);
                try {
                    long copyBytes = FileUtils.copyToFile(in, file);
                    long size = entry.getSize();
                    if (size != -1L && copyBytes != size) {
                        throw new IOException("copyBytes != size: " + copyBytes + " != " + size);
                    }
                    if (entryTime == -1L) continue;
                    file.setLastModified(entryTime);
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
            for (Map.Entry entry : directoryModifyTimes.entrySet()) {
                ((File)entry.getKey()).setLastModified((Long)entry.getValue());
            }
        }
    }

    public static void mergeUnzip(File destination, File ... zipFiles) throws IOException {
        ZipUtils.mergeUnzip(null, destination, zipFiles);
    }

    public static void mergeUnzip(ZipEntryFilter filter, File destination, File ... zipFiles) throws IOException {
        if (zipFiles.length > 0) {
            if (zipFiles.length == 1) {
                ZipUtils.unzip(zipFiles[0], "", destination, filter);
            } else {
                throw new NotImplementedException("Implement merge feature when first needed");
            }
        }
    }

    public static void copyEntries(File file, ZipOutputStream zipOut) throws IOException {
        ZipUtils.copyEntries(file, zipOut, null);
    }

    public static void copyEntries(File file, ZipOutputStream zipOut, ZipEntryFilter filter) throws IOException {
        try (ZipFile zipFile = new ZipFile(file);){
            ZipUtils.copyEntries(zipFile, zipOut, filter);
        }
    }

    public static void copyEntries(ZipFile zipFile, ZipOutputStream zipOut) throws IOException {
        ZipUtils.copyEntries(zipFile, zipOut, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyEntries(ZipFile zipFile, ZipOutputStream zipOut, ZipEntryFilter filter) throws IOException {
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (filter != null && !filter.accept(entry)) continue;
            ZipEntry newEntry = new ZipEntry(entry.getName());
            long time = entry.getTime();
            if (time != -1L) {
                newEntry.setTime(time);
            }
            zipOut.putNextEntry(newEntry);
            try {
                InputStream in = zipFile.getInputStream(entry);
                try {
                    IoUtils.copy(in, zipOut);
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
            finally {
                zipOut.closeEntry();
            }
        }
    }
}

