/*
 * Decompiled with CFR 0.152.
 */
package com.aoapps.lang;

import com.aoapps.lang.Throwables;
import com.aoapps.lang.i18n.Resources;
import java.util.ResourceBundle;

public class NullArgumentException
extends IllegalArgumentException {
    private static final Resources RESOURCES = Resources.getResources(ResourceBundle::getBundle, NullArgumentException.class.getPackage(), "i18nres.ApplicationResources", NullArgumentException.class.getSimpleName() + '.');
    private static final long serialVersionUID = 1L;
    private final String argument;

    public static <T> T checkNotNull(T argument) throws NullArgumentException {
        return NullArgumentException.checkNotNull(argument, null);
    }

    public static <T> T checkNotNull(T argument, String argumentName) throws NullArgumentException {
        if (argument == null) {
            throw new NullArgumentException(argumentName);
        }
        return argument;
    }

    public NullArgumentException(String argument) {
        super(argument == null ? RESOURCES.getMessage("message.noName") : RESOURCES.getMessage("message", argument));
        this.argument = argument;
    }

    @Override
    public String getLocalizedMessage() {
        return this.argument == null ? RESOURCES.getMessage("message.noName") : RESOURCES.getMessage("message", this.argument);
    }

    public String getArgument() {
        return this.argument;
    }

    static {
        Throwables.registerSurrogateFactory(NullArgumentException.class, (template, cause) -> {
            NullArgumentException newEx = new NullArgumentException(template.argument);
            newEx.initCause(cause);
            return newEx;
        });
    }
}

