/*
 * Decompiled with CFR 0.152.
 */
package com.aoapps.lang;

import com.aoapps.lang.io.Encoder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.List;

public final class Strings {
    private static final String[] MONTHS = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static final char[] wordWrapChars = new char[]{' ', '\t', '-', '=', ',', ';'};
    private static final String lineSeparator = System.lineSeparator();
    @Deprecated
    private static final char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private Strings() {
        throw new AssertionError();
    }

    @Deprecated
    public static String getMonth(int month) {
        return MONTHS[month];
    }

    public static String join(Iterable<?> objects, String delimiter) throws ConcurrentModificationException {
        int delimiterLength = delimiter.length();
        int totalLength = 0;
        boolean didOne = false;
        for (Object obj : objects) {
            if (didOne) {
                totalLength += delimiterLength;
            } else {
                didOne = true;
            }
            totalLength += String.valueOf(obj).length();
        }
        StringBuilder sb = new StringBuilder(totalLength);
        didOne = false;
        for (Object obj : objects) {
            if (didOne) {
                sb.append(delimiter);
            } else {
                didOne = true;
            }
            sb.append(obj);
        }
        if (totalLength != sb.length()) {
            throw new ConcurrentModificationException();
        }
        return sb.toString();
    }

    public static <A extends Appendable> A join(Iterable<?> objects, String delimiter, A out) throws IOException {
        boolean didOne = false;
        for (Object obj : objects) {
            if (didOne) {
                out.append(delimiter);
            } else {
                didOne = true;
            }
            out.append(String.valueOf(obj));
        }
        return out;
    }

    public static String join(Object[] objects, String delimiter) throws ConcurrentModificationException {
        int delimiterLength = delimiter.length();
        int totalLength = 0;
        boolean didOne = false;
        for (Object obj : objects) {
            if (didOne) {
                totalLength += delimiterLength;
            } else {
                didOne = true;
            }
            totalLength += String.valueOf(obj).length();
        }
        StringBuilder sb = new StringBuilder(totalLength);
        didOne = false;
        for (Object obj : objects) {
            if (didOne) {
                sb.append(delimiter);
            } else {
                didOne = true;
            }
            sb.append(obj);
        }
        if (totalLength != sb.length()) {
            throw new ConcurrentModificationException();
        }
        return sb.toString();
    }

    public static <A extends Appendable> A join(Object[] objects, String delimiter, A out) throws IOException {
        boolean didOne = false;
        for (Object obj : objects) {
            if (didOne) {
                out.append(delimiter);
            } else {
                didOne = true;
            }
            out.append(String.valueOf(obj));
        }
        return out;
    }

    public static boolean containsIgnoreCase(String line, String word) {
        int wordlen = word.length();
        int linelen = line.length();
        int end = linelen - wordlen;
        block0: for (int c = 0; c <= end; ++c) {
            for (int d = 0; d < wordlen; ++d) {
                char ch1 = line.charAt(c + d);
                char ch2 = word.charAt(d);
                if (ch1 >= 'A' && ch1 <= 'Z') {
                    ch1 = (char)(ch1 + 32);
                }
                if (ch2 >= 'A' && ch2 <= 'Z') {
                    ch2 = (char)(ch2 + 32);
                }
                if (ch1 != ch2) continue block0;
            }
            return true;
        }
        return false;
    }

    public static int countOccurrences(byte[] buff, int len, String word) {
        int wordlen = word.length();
        int end = len - wordlen;
        int count = 0;
        block0: for (int c = 0; c <= end; ++c) {
            for (int d = 0; d < wordlen; ++d) {
                char ch2;
                char ch1 = (char)buff[c + d];
                if (ch1 <= 'Z' && ch1 >= 'A') {
                    ch1 = (char)(ch1 + 32);
                }
                if ((ch2 = word.charAt(d)) <= 'Z' && ch2 >= 'A') {
                    ch2 = (char)(ch2 + 32);
                }
                if (ch1 != ch2) continue block0;
            }
            c += wordlen - 1;
            ++count;
        }
        return count;
    }

    public static int countOccurrences(byte[] buff, String word) {
        int wordlen = word.length();
        int end = buff.length - wordlen;
        int count = 0;
        block0: for (int c = 0; c <= end; ++c) {
            for (int d = 0; d < wordlen; ++d) {
                char ch2;
                char ch1 = (char)buff[c + d];
                if (ch1 <= 'Z' && ch1 >= 'A') {
                    ch1 = (char)(ch1 + 32);
                }
                if ((ch2 = word.charAt(d)) <= 'Z' && ch2 >= 'A') {
                    ch2 = (char)(ch2 + 32);
                }
                if (ch1 != ch2) continue block0;
            }
            c += wordlen - 1;
            ++count;
        }
        return count;
    }

    public static int countOccurrences(String line, String word) {
        int wordlen = word.length();
        int end = line.length() - wordlen;
        int count = 0;
        block0: for (int c = 0; c <= end; ++c) {
            for (int d = 0; d < wordlen; ++d) {
                char ch2;
                char ch1 = line.charAt(c + d);
                if (ch1 <= 'Z' && ch1 >= 'A') {
                    ch1 = (char)(ch1 + 32);
                }
                if ((ch2 = word.charAt(d)) <= 'Z' && ch2 >= 'A') {
                    ch2 = (char)(ch2 + 32);
                }
                if (ch1 != ch2) continue block0;
            }
            c += wordlen - 1;
            ++count;
        }
        return count;
    }

    public static String getTimeLengthString(long time) {
        StringBuilder sb = new StringBuilder();
        if (time < 0L) {
            sb.append('-');
            time = -time;
        }
        long days = time / 86400000L;
        int hours = (int)((time -= days * 86400000L) / 3600000L);
        int minutes = (int)((time -= (long)(hours * 3600000)) / 60000L);
        int seconds = (int)((time -= (long)(minutes * 60000)) / 1000L);
        time -= (long)(seconds * 1000);
        if (days == 0L) {
            if (hours == 0) {
                if (minutes == 0) {
                    if (seconds == 0) {
                        if (time == 0L) {
                            sb.append("0 minutes");
                        } else {
                            sb.append(time).append(time == 1L ? " millisecond" : " milliseconds");
                        }
                    } else {
                        sb.append(seconds).append(seconds == 1 ? " second" : " seconds");
                    }
                } else {
                    sb.append(minutes).append(minutes == 1 ? " minute" : " minutes");
                }
            } else if (minutes == 0) {
                sb.append(hours).append(hours == 1 ? " hour" : " hours");
            } else {
                sb.append(hours).append(hours == 1 ? " hour and " : " hours and ").append(minutes).append(minutes == 1 ? " minute" : " minutes");
            }
        } else if (hours == 0) {
            if (minutes == 0) {
                sb.append(days).append(days == 1L ? " day" : " days");
            } else {
                sb.append(days).append(days == 1L ? " day and " : " days and ").append(minutes).append(minutes == 1 ? " minute" : " minutes");
            }
        } else if (minutes == 0) {
            sb.append(days).append(days == 1L ? " day and " : " days and ").append(hours).append(hours == 1 ? " hour" : " hours");
        } else {
            sb.append(days).append(days == 1L ? " day, " : " days, ").append(hours).append(hours == 1 ? " hour and " : " hours and ").append(minutes).append(minutes == 1 ? " minute" : " minutes");
        }
        return sb.toString();
    }

    public static String getDecimalTimeLengthString(long time) {
        return Strings.getDecimalTimeLengthString(time, true);
    }

    public static String getDecimalTimeLengthString(long time, boolean alwaysShowMillis) {
        StringBuilder sb = new StringBuilder();
        if (time < 0L) {
            sb.append('-');
            time = -time;
        }
        long days = time / 86400000L;
        int hours = (int)((time -= days * 86400000L) / 3600000L);
        int minutes = (int)((time -= (long)(hours * 3600000)) / 60000L);
        int seconds = (int)((time -= (long)(minutes * 60000)) / 1000L);
        time -= (long)(seconds * 1000);
        if (days > 0L) {
            sb.append(days).append(days == 1L ? " day, " : " days, ");
        }
        sb.append(hours).append(':');
        if (minutes < 10) {
            sb.append('0');
        }
        sb.append(minutes).append(':');
        if (seconds < 10) {
            sb.append('0');
        }
        sb.append(seconds);
        if (alwaysShowMillis || time != 0L) {
            sb.append('.');
            if (time < 10L) {
                sb.append("00");
            } else if (time < 100L) {
                sb.append('0');
            }
            sb.append(time);
        }
        return sb.toString();
    }

    public static int indexOf(String s, char[] chars) {
        return Strings.indexOf(s, chars, 0);
    }

    public static int indexOf(String s, char[] chars, int start) {
        int slen = s.length();
        int clen = chars.length;
        for (int c = start; c < slen; ++c) {
            char ch = s.charAt(c);
            for (int d = 0; d < clen; ++d) {
                if (ch != chars[d]) continue;
                return c;
            }
        }
        return -1;
    }

    public static int indexOf(String s, BitSet chars) {
        return Strings.indexOf(s, chars, 0);
    }

    public static int indexOf(String s, BitSet chars, int start) {
        int len = s.length();
        for (int c = start; c < len; ++c) {
            if (!chars.get(s.charAt(c))) continue;
            return c;
        }
        return -1;
    }

    public static String replace(String string, char ch, String replacement) {
        int pos = string.indexOf(ch);
        if (pos == -1) {
            return string;
        }
        int len = string.length();
        StringBuilder sb = new StringBuilder(len + 16);
        int lastpos = 0;
        do {
            sb.append(string, lastpos, pos).append(replacement);
        } while ((pos = string.indexOf(ch, lastpos = pos + 1)) != -1);
        if (lastpos < len) {
            sb.append(string, lastpos, len);
        }
        return sb.toString();
    }

    public static String replace(String string, String find, String replacement) {
        int pos = string.indexOf(find);
        if (pos == -1) {
            return string;
        }
        int len = string.length();
        StringBuilder sb = new StringBuilder(len + 16);
        int lastpos = 0;
        int findLen = find.length();
        do {
            sb.append(string, lastpos, pos).append(replacement);
        } while ((pos = string.indexOf(find, lastpos = pos + findLen)) != -1);
        if (lastpos < len) {
            sb.append(string, lastpos, len);
        }
        return sb.toString();
    }

    public static void replace(String string, char find, String replacement, Appendable out) throws IOException {
        int pos = string.indexOf(find);
        if (pos == -1) {
            out.append(string);
        } else {
            int lastpos = 0;
            do {
                out.append(string, lastpos, pos).append(replacement);
            } while ((pos = string.indexOf(find, lastpos = pos + 1)) != -1);
            int len = string.length();
            if (lastpos < len) {
                out.append(string, lastpos, len);
            }
        }
    }

    public static void replace(String string, String find, String replacement, Appendable out) throws IOException {
        int pos = string.indexOf(find);
        if (pos == -1) {
            out.append(string);
        } else {
            int lastpos = 0;
            int findLen = find.length();
            do {
                out.append(string, lastpos, pos).append(replacement);
            } while ((pos = string.indexOf(find, lastpos = pos + findLen)) != -1);
            int len = string.length();
            if (lastpos < len) {
                out.append(string, lastpos, len);
            }
        }
    }

    public static void replace(String string, char find, String replacement, Appendable out, Encoder encoder) throws IOException {
        if (encoder == null) {
            Strings.replace(string, find, replacement, out);
        } else {
            int pos = string.indexOf(find);
            if (pos == -1) {
                encoder.append(string, out);
            } else {
                int lastpos = 0;
                do {
                    encoder.append(string, lastpos, pos, out).append(replacement, out);
                } while ((pos = string.indexOf(find, lastpos = pos + 1)) != -1);
                int len = string.length();
                if (lastpos < len) {
                    encoder.append(string, lastpos, len, out);
                }
            }
        }
    }

    public static void replace(String string, String find, String replacement, Appendable out, Encoder encoder) throws IOException {
        if (encoder == null) {
            Strings.replace(string, find, replacement, out);
        } else {
            int pos = string.indexOf(find);
            if (pos == -1) {
                encoder.append(string, out);
            } else {
                int lastpos = 0;
                int findLen = find.length();
                do {
                    encoder.append(string, lastpos, pos, out).append(replacement, out);
                } while ((pos = string.indexOf(find, lastpos = pos + findLen)) != -1);
                int len = string.length();
                if (lastpos < len) {
                    encoder.append(string, lastpos, len, out);
                }
            }
        }
    }

    public static void replace(StringBuffer sb, String find, String replacement) {
        for (int pos = 0; pos < sb.length() && (pos = sb.indexOf(find, pos)) != -1; pos += replacement.length()) {
            sb.replace(pos, pos + find.length(), replacement);
        }
    }

    public static void replace(StringBuilder sb, String find, String replacement) {
        for (int pos = 0; pos < sb.length() && (pos = sb.indexOf(find, pos)) != -1; pos += replacement.length()) {
            sb.replace(pos, pos + find.length(), replacement);
        }
    }

    public static List<String> splitLines(String s) {
        int pos;
        ArrayList<String> v = new ArrayList<String>();
        int start = 0;
        while ((pos = s.indexOf(10, start)) != -1) {
            String line = pos > start && s.charAt(pos - 1) == '\r' ? s.substring(start, pos - 1) : s.substring(start, pos);
            v.add(line);
            start = pos + 1;
        }
        int slen = s.length();
        if (start < slen) {
            if (s.charAt(slen - 1) == '\r') {
                --slen;
            }
            String line = s.substring(start, slen);
            v.add(line);
        }
        return v;
    }

    public static String[] split(String line) {
        int len = line.length();
        int wordCount = 0;
        int pos = 0;
        while (pos < len) {
            int cp;
            while (pos < len && Strings.isWhitespace(cp = line.codePointAt(pos))) {
                pos += Character.charCount(cp);
            }
            int start = pos;
            while (pos < len && !Strings.isWhitespace(cp = line.codePointAt(pos))) {
                pos += Character.charCount(cp);
            }
            if (pos <= start) continue;
            ++wordCount;
        }
        String[] words = new String[wordCount];
        int wordPos = 0;
        pos = 0;
        while (pos < len) {
            int cp;
            while (pos < len && Strings.isWhitespace(cp = line.codePointAt(pos))) {
                pos += Character.charCount(cp);
            }
            int start = pos;
            while (pos < len && !Strings.isWhitespace(cp = line.codePointAt(pos))) {
                pos += Character.charCount(cp);
            }
            if (pos <= start) continue;
            words[wordPos++] = line.substring(start, pos);
        }
        return words;
    }

    @Deprecated
    public static int split(String line, char[][][] buff) {
        int len = line.length();
        int wordCount = 0;
        int pos = 0;
        while (pos < len) {
            int cp;
            while (pos < len && Strings.isWhitespace(cp = line.codePointAt(pos))) {
                pos += Character.charCount(cp);
            }
            int start = pos;
            while (pos < len && !Strings.isWhitespace(cp = line.codePointAt(pos))) {
                pos += Character.charCount(cp);
            }
            if (pos <= start) continue;
            ++wordCount;
        }
        Object words = buff[0];
        if (words == null || ((char[][])words).length < wordCount) {
            char[][] cArrayArray = new char[wordCount][];
            words = cArrayArray;
            buff[0] = cArrayArray;
        }
        int wordPos = 0;
        pos = 0;
        while (pos < len) {
            int cp;
            while (pos < len && Strings.isWhitespace(cp = line.codePointAt(pos))) {
                pos += Character.charCount(cp);
            }
            int start = pos;
            while (pos < len && !Strings.isWhitespace(cp = line.codePointAt(pos))) {
                pos += Character.charCount(cp);
            }
            if (pos <= start) continue;
            int n = wordPos++;
            char[] cArray = new char[pos - start];
            words[n] = cArray;
            char[] tch = cArray;
            line.getChars(start, pos, tch, 0);
        }
        return wordCount;
    }

    @Deprecated
    public static int split(String line, String[][] buff) {
        int len = line.length();
        int wordCount = 0;
        int pos = 0;
        while (pos < len) {
            int cp;
            while (pos < len && Strings.isWhitespace(cp = line.codePointAt(pos))) {
                pos += Character.charCount(cp);
            }
            int start = pos;
            while (pos < len && !Strings.isWhitespace(cp = line.codePointAt(pos))) {
                pos += Character.charCount(cp);
            }
            if (pos <= start) continue;
            ++wordCount;
        }
        String[] words = buff[0];
        if (words == null || words.length < wordCount) {
            words = new String[wordCount];
            buff[0] = words;
        }
        int wordPos = 0;
        pos = 0;
        while (pos < len) {
            int cp;
            while (pos < len && Strings.isWhitespace(cp = line.codePointAt(pos))) {
                pos += Character.charCount(cp);
            }
            int start = pos;
            while (pos < len && !Strings.isWhitespace(cp = line.codePointAt(pos))) {
                pos += Character.charCount(cp);
            }
            if (pos <= start) continue;
            words[wordPos++] = line.substring(start, pos);
        }
        return wordCount;
    }

    public static List<String> split(String line, char delim) {
        return Strings.split(line, 0, line.length(), delim, new ArrayList());
    }

    public static <C extends Collection<String>> C split(String line, char delim, C words) {
        return Strings.split(line, 0, line.length(), delim, words);
    }

    public static List<String> split(String line, int begin, int end, char delim) {
        return Strings.split(line, begin, end, delim, new ArrayList());
    }

    public static <C extends Collection<String>> C split(String line, int begin, int end, char delim, C words) {
        for (int pos = begin; pos < end; ++pos) {
            int start = pos;
            if ((pos = line.indexOf(delim, pos)) == -1 || pos > end) {
                pos = end;
            }
            words.add((String)line.substring(start, pos));
        }
        if (end > begin && line.charAt(end - 1) == delim) {
            words.add((String)"");
        }
        return words;
    }

    public static List<String> split(String line, String delim) {
        int delimLen = delim.length();
        if (delimLen == 0) {
            throw new IllegalArgumentException("Delimiter may not be empty");
        }
        ArrayList<String> words = new ArrayList<String>();
        int len = line.length();
        int pos = 0;
        while (pos < len) {
            int start = pos;
            if ((pos = line.indexOf(delim, pos)) == -1) {
                words.add(line.substring(start, len));
                pos = len;
                continue;
            }
            words.add(line.substring(start, pos));
            pos += delimLen;
        }
        if (len >= delimLen && line.endsWith(delim)) {
            words.add("");
        }
        return words;
    }

    public static List<String> splitCommaSpace(String line) {
        ArrayList<String> words = new ArrayList<String>();
        int len = line.length();
        int pos = 0;
        while (pos < len) {
            int cp;
            while (pos < len && ((cp = line.codePointAt(pos)) == 44 || Strings.isWhitespace(cp))) {
                pos += Character.charCount(cp);
            }
            int start = pos;
            while (pos < len && (cp = line.codePointAt(pos)) != 44 && !Strings.isWhitespace(cp)) {
                pos += Character.charCount(cp);
            }
            if (pos <= start) continue;
            words.add(line.substring(start, pos));
        }
        return words;
    }

    @Deprecated
    public static String wordWrap(String string, int width) {
        int inputLength = string.length();
        int estimatedLines = 2 * inputLength / width;
        int initialLength = inputLength + estimatedLines * 2;
        try {
            StringBuilder buffer = new StringBuilder(initialLength);
            Strings.wordWrap(string, width, buffer);
            return buffer.toString();
        }
        catch (IOException e) {
            throw new AssertionError("Should not get IOException from StringBuilder", e);
        }
    }

    public static void wordWrap(String string, int width, Appendable out) throws IOException {
        ++width;
        boolean useCarriageReturn = false;
        do {
            int d;
            boolean isBreak;
            char ch;
            int c;
            int pos = string.indexOf(10);
            if (!useCarriageReturn && pos > 0 && string.charAt(pos - 1) == '\r') {
                useCarriageReturn = true;
            }
            int linelength = pos == -1 ? string.length() : pos + 1;
            if ((pos == -1 ? linelength - 1 : pos) <= width) {
                out.append(string, 0, linelength);
                string = string.substring(linelength);
                continue;
            }
            int lastBreakChar = 0;
            for (c = 0; c < width; ++c) {
                ch = string.charAt(c);
                isBreak = false;
                for (d = 0; d < wordWrapChars.length; ++d) {
                    if (ch != wordWrapChars[d]) continue;
                    isBreak = true;
                    break;
                }
                if (!isBreak) continue;
                lastBreakChar = c + 1;
            }
            if (lastBreakChar == 0) {
                for (c = width; c < linelength; ++c) {
                    ch = string.charAt(c);
                    isBreak = false;
                    for (d = 0; d < wordWrapChars.length; ++d) {
                        if (ch != wordWrapChars[d]) continue;
                        isBreak = true;
                        break;
                    }
                    if (!isBreak) continue;
                    lastBreakChar = c + 1;
                    break;
                }
            }
            if (lastBreakChar == 0) {
                out.append(string, 0, linelength);
                string = string.substring(linelength);
                continue;
            }
            out.append(string, 0, lastBreakChar);
            if (useCarriageReturn) {
                out.append("\r\n");
            } else {
                out.append('\n');
            }
            string = string.substring(lastBreakChar);
        } while (string.length() > 0);
    }

    @Deprecated
    public static char getHexChar(int v) {
        return hexChars[v & 0xF];
    }

    @Deprecated
    public static int getHex(char ch) throws IllegalArgumentException {
        switch (ch) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': 
            case 'a': {
                return 10;
            }
            case 'B': 
            case 'b': {
                return 11;
            }
            case 'C': 
            case 'c': {
                return 12;
            }
            case 'D': 
            case 'd': {
                return 13;
            }
            case 'E': 
            case 'e': {
                return 14;
            }
            case 'F': 
            case 'f': {
                return 15;
            }
        }
        throw new IllegalArgumentException("Invalid hex character: " + ch);
    }

    @Deprecated
    public static void convertToHex(byte[] bytes, Appendable out) throws IOException {
        if (bytes != null) {
            for (byte b : bytes) {
                out.append(Strings.getHexChar(b >> 4));
                out.append(Strings.getHexChar(b));
            }
        }
    }

    @Deprecated
    public static String convertToHex(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        int len = bytes.length;
        StringBuilder sb = new StringBuilder(len * 2);
        try {
            Strings.convertToHex(bytes, (Appendable)sb);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return sb.toString();
    }

    @Deprecated
    public static byte[] convertByteArrayFromHex(char[] hex) {
        int hexLen = hex.length;
        if ((hexLen & 1) != 0) {
            throw new IllegalArgumentException("Uneven number of characters: " + hexLen);
        }
        byte[] result = new byte[hexLen / 2];
        int resultPos = 0;
        int hexPos = 0;
        while (hexPos < hexLen) {
            int h = Strings.getHex(hex[hexPos++]);
            int l = Strings.getHex(hex[hexPos++]);
            result[resultPos++] = (byte)(h << 4 | l);
        }
        return result;
    }

    @Deprecated
    public static void convertToHex(int value, Appendable out) throws IOException {
        out.append(Strings.getHexChar(value >>> 28));
        out.append(Strings.getHexChar(value >>> 24));
        out.append(Strings.getHexChar(value >>> 20));
        out.append(Strings.getHexChar(value >>> 16));
        out.append(Strings.getHexChar(value >>> 12));
        out.append(Strings.getHexChar(value >>> 8));
        out.append(Strings.getHexChar(value >>> 4));
        out.append(Strings.getHexChar(value));
    }

    @Deprecated
    public static String convertToHex(int value) {
        StringBuilder sb = new StringBuilder(8);
        try {
            Strings.convertToHex(value, (Appendable)sb);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return sb.toString();
    }

    @Deprecated
    public static int convertIntArrayFromHex(char[] hex) {
        int hexLen = hex.length;
        if (hexLen < 8) {
            throw new IllegalArgumentException("Too few characters: " + hexLen);
        }
        return Strings.getHex(hex[0]) << 28 | Strings.getHex(hex[1]) << 24 | Strings.getHex(hex[2]) << 20 | Strings.getHex(hex[3]) << 16 | Strings.getHex(hex[4]) << 12 | Strings.getHex(hex[5]) << 8 | Strings.getHex(hex[6]) << 4 | Strings.getHex(hex[7]);
    }

    @Deprecated
    public static void convertToHex(long value, Appendable out) throws IOException {
        Strings.convertToHex((int)(value >>> 32), out);
        Strings.convertToHex((int)value, out);
    }

    @Deprecated
    public static String convertToHex(long value) {
        StringBuilder sb = new StringBuilder(16);
        try {
            Strings.convertToHex(value, (Appendable)sb);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return sb.toString();
    }

    @Deprecated
    public static long convertLongArrayFromHex(char[] hex) {
        int hexLen = hex.length;
        if (hexLen < 16) {
            throw new IllegalArgumentException("Too few characters: " + hexLen);
        }
        int h = Strings.getHex(hex[0]) << 28 | Strings.getHex(hex[1]) << 24 | Strings.getHex(hex[2]) << 20 | Strings.getHex(hex[3]) << 16 | Strings.getHex(hex[4]) << 12 | Strings.getHex(hex[5]) << 8 | Strings.getHex(hex[6]) << 4 | Strings.getHex(hex[7]);
        int l = Strings.getHex(hex[8]) << 28 | Strings.getHex(hex[9]) << 24 | Strings.getHex(hex[10]) << 20 | Strings.getHex(hex[11]) << 16 | Strings.getHex(hex[12]) << 12 | Strings.getHex(hex[13]) << 8 | Strings.getHex(hex[14]) << 4 | Strings.getHex(hex[15]);
        return (long)h << 32 | (long)l & 0xFFFFFFFFL;
    }

    public static String getApproximateSize(long size) {
        long whole;
        long unitSize;
        String unitName;
        boolean neg;
        boolean bl = neg = size < 0L;
        if (neg) {
            long l = size = size == Long.MIN_VALUE ? Long.MAX_VALUE : -size;
        }
        if (size == 1L) {
            return "1 byte";
        }
        if (size < 1024L) {
            return (int)size + " bytes";
        }
        if (size < 0x100000L) {
            unitName = " k";
            unitSize = 1024L;
        } else if (size < 0x40000000L) {
            unitName = " M";
            unitSize = 0x100000L;
        } else if (size < 0x10000000000L) {
            unitName = " G";
            unitSize = 0x40000000L;
        } else {
            unitName = " T";
            unitSize = 0x10000000000L;
        }
        StringBuilder sb = new StringBuilder();
        if (neg) {
            sb.append('-');
        }
        if ((whole = size / unitSize) < 100L) {
            int fraction = (int)(size % unitSize * 10L / unitSize);
            return sb.append(whole).append('.').append(fraction).append(unitName).toString();
        }
        return sb.append(whole).append(unitName).toString();
    }

    public static String getApproximateBitRate(long bitRate) {
        long whole;
        long unitSize;
        String unitName;
        boolean neg;
        boolean bl = neg = bitRate < 0L;
        if (neg) {
            long l = bitRate = bitRate == Long.MIN_VALUE ? Long.MAX_VALUE : -bitRate;
        }
        if (bitRate < 1000L) {
            return Integer.toString((int)bitRate);
        }
        if (bitRate < 1000000L) {
            unitName = " k";
            unitSize = 1000L;
        } else if (bitRate < 1000000000L) {
            unitName = " M";
            unitSize = 1000000L;
        } else if (bitRate < 1000000000000L) {
            unitName = " G";
            unitSize = 1000000000L;
        } else {
            unitName = " T";
            unitSize = 1000000000000L;
        }
        StringBuilder sb = new StringBuilder();
        if (neg) {
            sb.append('-');
        }
        if ((whole = bitRate / unitSize) < 100L) {
            int fraction = (int)(bitRate % unitSize * 10L / unitSize);
            return sb.append(whole).append('.').append(fraction).append(unitName).toString();
        }
        return sb.append(whole).append(unitName).toString();
    }

    public static int compareToIgnoreCaseCarefulEquals(String s1, String s2) {
        int diff = s1.compareToIgnoreCase(s2);
        if (diff == 0) {
            diff = s1.compareTo(s2);
        }
        return diff;
    }

    public static int indexOf(String source, String target, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex>toIndex: fromIndex=" + fromIndex + ", toIndex=" + toIndex);
        }
        int sourceCount = source.length();
        if (toIndex < sourceCount) {
            sourceCount = toIndex;
        }
        int targetCount = target.length();
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        char first = target.charAt(0);
        int max = sourceCount - targetCount;
        for (int i = fromIndex; i <= max; ++i) {
            if (source.charAt(i) != first) {
                while (++i <= max && source.charAt(i) != first) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = 1;
            while (j < end && source.charAt(j) == target.charAt(k)) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i;
        }
        return -1;
    }

    public static String firstLineOnly(String value, int maxCharacters) {
        if (value == null) {
            return value;
        }
        int pos = value.indexOf(lineSeparator);
        if (pos == -1) {
            pos = value.length();
        }
        if (pos > maxCharacters) {
            pos = maxCharacters;
        }
        return pos == value.length() ? value : value.substring(0, pos) + '\u2026';
    }

    public static String nullIfEmpty(String value) {
        return value == null || value.isEmpty() ? null : value;
    }

    public static boolean isWhitespace(char ch) {
        return ch <= ' ' || Character.isWhitespace(ch);
    }

    public static boolean isWhitespace(int codePoint) {
        return codePoint <= 32 || Character.isWhitespace(codePoint);
    }

    public static String trim(String value) {
        int st;
        int cp;
        int valueLen;
        if (value == null) {
            return null;
        }
        int len = valueLen = value.length();
        for (st = 0; st < len && Strings.isWhitespace(cp = value.codePointAt(st)); st += Character.charCount(cp)) {
        }
        while (st < len && Strings.isWhitespace(cp = value.codePointBefore(len))) {
            if ((len -= Character.charCount(cp)) >= st) continue;
            len = st;
        }
        assert (st >= 0);
        assert (len <= valueLen);
        assert (st <= len);
        return st == 0 && len == valueLen ? value : (st == len ? "" : value.substring(st, len));
    }

    public static CharSequence trim(CharSequence value) {
        int st;
        int cp;
        int valueLen;
        if (value == null) {
            return null;
        }
        int len = valueLen = value.length();
        for (st = 0; st < len && Strings.isWhitespace(cp = Character.codePointAt(value, st)); st += Character.charCount(cp)) {
        }
        while (st < len && Strings.isWhitespace(cp = Character.codePointBefore(value, len))) {
            if ((len -= Character.charCount(cp)) >= st) continue;
            len = st;
        }
        assert (st >= 0);
        assert (len <= valueLen);
        assert (st <= len);
        return st == 0 && len == valueLen ? value : value.subSequence(st, len);
    }

    public static String trimNullIfEmpty(String value) {
        if (value != null && (value = Strings.trim(value)).isEmpty()) {
            value = null;
        }
        return value;
    }

    public static CharSequence trimNullIfEmpty(CharSequence value) {
        if (value != null && (value = Strings.trim(value)).length() == 0) {
            value = null;
        }
        return value;
    }
}

