/*
 * Decompiled with CFR 0.152.
 */
package com.aoapps.lang.concurrent;

import com.aoapps.lang.Throwables;
import java.util.concurrent.ExecutionException;
import java.util.function.BiFunction;

public final class ExecutionExceptions {
    private ExecutionExceptions() {
        throw new AssertionError();
    }

    public static <Ex extends Throwable> void wrapAndThrow(ExecutionException ee, Class<? extends Ex> exClass, BiFunction<? super String, ? super ExecutionException, ? extends Ex> exSupplier) throws Ex {
        Throwable cause;
        if (ee != null && exClass.isInstance(cause = ee.getCause())) {
            Throwable template = (Throwable)exClass.cast(cause);
            Throwable surrogate = Throwables.newSurrogate(template, ee);
            if (surrogate != template) {
                throw surrogate;
            }
            Throwable newExc = (Throwable)exSupplier.apply(template.getMessage(), ee);
            if (cause instanceof InterruptedException && !(newExc instanceof InterruptedException)) {
                Thread.currentThread().interrupt();
            }
            throw newExc;
        }
    }

    public static <Ex extends Throwable> void wrapAndThrowWithTemplate(ExecutionException ee, Class<? extends Ex> exClass, BiFunction<? super Ex, ? super ExecutionException, ? extends Ex> exSupplier) throws Ex {
        Throwable cause;
        if (ee != null && exClass.isInstance(cause = ee.getCause())) {
            Throwable template = (Throwable)exClass.cast(cause);
            Throwable surrogate = Throwables.newSurrogate(template, ee);
            if (surrogate != template) {
                throw surrogate;
            }
            Throwable newExc = (Throwable)exSupplier.apply(template, ee);
            if (cause instanceof InterruptedException && !(newExc instanceof InterruptedException)) {
                Thread.currentThread().interrupt();
            }
            throw newExc;
        }
    }
}

