/*
 * Decompiled with CFR 0.152.
 */
package com.aoapps.lang.concurrent;

import java.util.concurrent.Callable;

public class ThreadLocalCallable<T>
implements Callable<T> {
    private final Callable<T> task;
    private final ThreadLocal<?> threadLocal;
    private final Object value;

    public ThreadLocalCallable(Callable<T> task, ThreadLocal<?> threadLocal) {
        this.task = task;
        this.threadLocal = threadLocal;
        this.value = threadLocal.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T call() throws Exception {
        ThreadLocal<?> tl = this.threadLocal;
        Object oldValue = tl.get();
        Object newValue = this.value;
        try {
            if (oldValue != newValue) {
                tl.set(newValue);
            }
            T t = this.task.call();
            return t;
        }
        finally {
            if (oldValue != newValue) {
                if (oldValue == null) {
                    tl.remove();
                } else {
                    tl.set(oldValue);
                }
            }
        }
    }
}

