/*
 * Decompiled with CFR 0.152.
 */
package com.aoapps.lang.exception;

import com.aoapps.lang.Throwables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class WrappedExceptions
extends RuntimeException {
    private static final long serialVersionUID = -3938902089134728394L;
    private final List<Throwable> causes;

    private static List<Throwable> getUniqueCauses(Throwable ... causes) {
        int len = causes.length;
        ArrayList<Throwable> uniqueCauses = new ArrayList<Throwable>(len);
        for (Throwable cause : causes) {
            if (cause == null || uniqueCauses.contains(cause)) continue;
            uniqueCauses.add(cause);
        }
        return Collections.unmodifiableList(uniqueCauses);
    }

    public WrappedExceptions(Throwable ... causes) {
        this.causes = WrappedExceptions.getUniqueCauses(causes);
        if (!this.causes.isEmpty()) {
            this.initCause(this.causes.get(0));
        }
    }

    public WrappedExceptions(String message, Throwable ... causes) {
        super(message);
        this.causes = WrappedExceptions.getUniqueCauses(causes);
        if (!this.causes.isEmpty()) {
            this.initCause(this.causes.get(0));
        }
    }

    public List<Throwable> getCauses() {
        return this.causes;
    }

    static {
        Throwables.registerSurrogateFactory(WrappedExceptions.class, (template, cause) -> new WrappedExceptions(template.getMessage(), new Throwable[]{cause}));
    }
}

