/*
 * Decompiled with CFR 0.152.
 */
package com.aoapps.lang.io;

import com.aoapps.lang.Coercion;
import com.aoapps.lang.NullArgumentException;
import com.aoapps.lang.io.Encoder;
import com.aoapps.lang.io.NoClose;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

public class EncoderWriter
extends FilterWriter
implements NoClose {
    private final Encoder encoder;

    public EncoderWriter(Encoder encoder, Writer out, boolean outOptimized) {
        super(outOptimized ? out : Coercion.optimize(out, encoder));
        if (outOptimized) assert (out == Coercion.optimize(out, encoder));
        this.encoder = NullArgumentException.checkNotNull(encoder, "encoder");
    }

    public EncoderWriter(Encoder encoder, Writer out) {
        this(encoder, out, false);
    }

    public Encoder getEncoder() {
        return this.encoder;
    }

    public Writer getOut() {
        return this.out;
    }

    @Override
    public boolean isNoClose() {
        return this.out instanceof NoClose && ((NoClose)((Object)this.out)).isNoClose();
    }

    public void writePrefix() throws IOException {
        this.encoder.writePrefixTo(this.out);
    }

    @Override
    public void write(int c) throws IOException {
        this.encoder.write(c, this.out);
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        this.encoder.write(cbuf, this.out);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.encoder.write(cbuf, off, len, this.out);
    }

    @Override
    public void write(String str) throws IOException {
        this.encoder.write(str, this.out);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.encoder.write(str, off, len, this.out);
    }

    @Override
    public EncoderWriter append(char c) throws IOException {
        this.encoder.append(c, (Appendable)this.out);
        return this;
    }

    @Override
    public EncoderWriter append(CharSequence csq) throws IOException {
        this.encoder.append(csq, (Appendable)this.out);
        return this;
    }

    @Override
    public EncoderWriter append(CharSequence csq, int start, int end) throws IOException {
        this.encoder.append(csq, start, end, this.out);
        return this;
    }

    @Deprecated
    public final void writeSuffix() throws IOException {
        this.writeSuffix(false);
    }

    public void writeSuffix(boolean trim) throws IOException {
        this.encoder.writeSuffixTo(this.out, trim);
    }
}

