/*
 * Decompiled with CFR 0.152.
 */
package com.aoapps.lang.text;

import com.aoapps.lang.EmptyArrays;
import com.aoapps.lang.Throwables;
import com.aoapps.lang.exception.LocalizedException;
import com.aoapps.lang.i18n.Resources;
import java.io.Serializable;
import java.text.ParseException;

public class LocalizedParseException
extends ParseException
implements LocalizedException {
    private static final long serialVersionUID = 3L;
    protected final Resources resources;
    protected final String key;
    protected final Serializable[] args;

    public LocalizedParseException(int errorOffset, Resources resources, String key) {
        super(resources.getMessage(key), errorOffset);
        this.resources = resources;
        this.key = key;
        this.args = EmptyArrays.EMPTY_SERIALIZABLE_ARRAY;
    }

    public LocalizedParseException(int errorOffset, Resources resources, String key, Serializable ... args) {
        super(resources.getMessage(key, args), errorOffset);
        this.resources = resources;
        this.key = key;
        this.args = args;
    }

    @Override
    public String getLocalizedMessage() {
        return this.resources.getMessage(this.key, this.args);
    }

    @Override
    public final Resources getResources() {
        return this.resources;
    }

    @Override
    public final String getKey() {
        return this.key;
    }

    @Override
    public final Serializable[] getArgs() {
        return this.args;
    }

    static {
        Throwables.registerSurrogateFactory(LocalizedParseException.class, (template, cause) -> {
            LocalizedParseException newEx = new LocalizedParseException(template.getErrorOffset(), template.resources, template.key, template.args);
            newEx.initCause(cause);
            return newEx;
        });
    }
}

