/*
 * Decompiled with CFR 0.152.
 */
package com.aoapps.lang.util;

import com.aoapps.lang.Throwables;
import com.aoapps.lang.exception.WrappedException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

public final class GetOpt {
    private GetOpt() {
        throw new AssertionError();
    }

    public static <T> T parse(String value, Class<T> type) {
        if (value == null) {
            throw new IllegalArgumentException("value == null");
        }
        if (type == String.class) {
            return (T)value;
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return (T)Integer.valueOf(value);
        }
        if (type == Long.TYPE || type == Long.class) {
            return (T)Long.valueOf(value);
        }
        if (type == Short.TYPE || type == Short.class) {
            return (T)Short.valueOf(value);
        }
        if (type == Byte.TYPE || type == Byte.class) {
            return (T)Byte.valueOf(value);
        }
        if (type == Float.TYPE || type == Float.class) {
            return (T)Float.valueOf(value);
        }
        if (type == Double.TYPE || type == Double.class) {
            return (T)Double.valueOf(value);
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return (T)Boolean.valueOf(value);
        }
        if (type == Character.TYPE || type == Character.class) {
            int len = value.length();
            if (value.length() != 1) {
                throw new IllegalArgumentException("value.length != 1: " + len);
            }
            return (T)Character.valueOf(value.charAt(0));
        }
        try {
            Method method = type.getMethod("valueOf", String.class);
            int modifiers = method.getModifiers();
            if (Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers)) {
                Object result = method.invoke(null, value);
                if (result == null) {
                    throw new AssertionError((Object)"result == null");
                }
                return (T)result;
            }
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            throw Throwables.wrap(cause == null ? e : cause, WrappedException.class, WrappedException::new);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            // empty catch block
        }
        try {
            return type.getConstructor(String.class).newInstance(value);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            throw Throwables.wrap(cause == null ? e : cause, WrappedException.class, WrappedException::new);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> T getOpt(String[] args, String name, Class<T> type) {
        String booleanPrefix = "--" + name;
        String paramPrefix = booleanPrefix + '=';
        Boolean value = null;
        for (int c = 0; c < args.length; ++c) {
            String arg = args[c];
            if (arg == null) continue;
            if ("--".equals(arg)) break;
            if (arg.startsWith(paramPrefix)) {
                value = (Boolean)GetOpt.parse(arg.substring(paramPrefix.length()), type);
                args[c] = null;
                continue;
            }
            if (type != Boolean.TYPE && type != Boolean.class || !arg.equals(booleanPrefix)) continue;
            value = Boolean.TRUE;
            args[c] = null;
        }
        return (T)value;
    }

    public static List<String> getArguments(String[] args) {
        String arg;
        int c;
        ArrayList<String> arguments = new ArrayList<String>(args.length);
        for (c = 0; c < args.length; ++c) {
            arg = args[c];
            if (arg == null) continue;
            if (arg.startsWith("--")) {
                if ("--".equals(arg)) break;
                throw new IllegalArgumentException("Unexpected parameter: " + arg);
            }
            arguments.add(arg);
        }
        while (c < args.length) {
            arg = args[c];
            if (arg != null) {
                arguments.add(arg);
            }
            ++c;
        }
        return arguments;
    }
}

