/*
 * Decompiled with CFR 0.152.
 */
package com.aoapps.lang.validation;

import com.aoapps.lang.LocalizedIllegalArgumentException;
import com.aoapps.lang.Throwables;
import com.aoapps.lang.i18n.Resources;
import com.aoapps.lang.validation.ValidationResult;
import java.util.ResourceBundle;

public class ValidationException
extends Exception {
    private static final Resources RESOURCES = Resources.getResources(ResourceBundle::getBundle, ValidationException.class);
    private static final long serialVersionUID = -1153407618428602416L;
    private final ValidationResult result;

    public ValidationException(ValidationResult result) {
        super(result.toString());
        if (result.isValid()) {
            throw new LocalizedIllegalArgumentException(RESOURCES, "init.validResult");
        }
        this.result = result;
    }

    public ValidationException(Throwable cause, ValidationResult result) {
        super(result.toString(), cause);
        if (result.isValid()) {
            throw new LocalizedIllegalArgumentException(RESOURCES, "init.validResult");
        }
        this.result = result;
    }

    @Override
    public String getLocalizedMessage() {
        return this.result.toString();
    }

    public ValidationResult getResult() {
        return this.result;
    }

    static {
        Throwables.registerSurrogateFactory(ValidationException.class, (template, cause) -> new ValidationException(cause, template.result));
    }
}

