/*
 * Decompiled with CFR 0.152.
 */
package com.aoapps.lang.xml;

import com.aoapps.lang.NullArgumentException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class XmlUtils {
    public static final int INDENT_SPACES = 2;

    private XmlUtils() {
        throw new AssertionError();
    }

    public static Document parseXml(URL url) throws IOException, ParserConfigurationException, SAXException {
        URLConnection conn = url.openConnection();
        try (InputStream in = conn.getInputStream();){
            Document document = XmlUtils.parseXml(in);
            return document;
        }
    }

    public static Document parseXml(InputStream in) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (ParserConfigurationException e) {
            throw new AssertionError("All implementations are required to support the javax.xml.XMLConstants.FEATURE_SECURE_PROCESSING feature.", e);
        }
        dbf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        dbf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        return dbf.newDocumentBuilder().parse(in);
    }

    public static Iterable<Node> iterableNodes(final NodeList nodeList) {
        return () -> new Iterator<Node>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < nodeList.getLength();
            }

            @Override
            public Node next() throws NoSuchElementException {
                if (this.hasNext()) {
                    return nodeList.item(this.index++);
                }
                throw new NoSuchElementException();
            }
        };
    }

    public static Iterable<Element> iterableElements(final NodeList nodeList) {
        return () -> new Iterator<Element>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                while (this.index < nodeList.getLength() && !(nodeList.item(this.index) instanceof Element)) {
                    ++this.index;
                }
                return this.index < nodeList.getLength();
            }

            @Override
            public Element next() throws NoSuchElementException {
                if (this.hasNext()) {
                    return (Element)nodeList.item(this.index++);
                }
                throw new NoSuchElementException();
            }
        };
    }

    public static Iterable<Element> iterableChildElementsByTagName(final Element element, final String childTagName) {
        return () -> new Iterator<Element>(){
            private final NodeList children;
            private int index;
            {
                this.children = element.getChildNodes();
                this.index = 0;
            }

            @Override
            public boolean hasNext() {
                Element childElem;
                Node child;
                while (!(this.index >= this.children.getLength() || (child = this.children.item(this.index)) instanceof Element && childTagName.equals((childElem = (Element)child).getTagName()))) {
                    ++this.index;
                }
                return this.index < this.children.getLength();
            }

            @Override
            public Element next() throws NoSuchElementException {
                if (this.hasNext()) {
                    return (Element)this.children.item(this.index++);
                }
                throw new NoSuchElementException();
            }
        };
    }

    public static Element getChildElementByTagName(Element element, String childTagName) {
        Element matched = null;
        NodeList children = element.getChildNodes();
        int len = children.getLength();
        for (int index = 0; index < len; ++index) {
            Element childElem;
            Node child = children.item(index);
            if (!(child instanceof Element) || !childTagName.equals((childElem = (Element)child).getTagName())) continue;
            if (matched != null) {
                throw new IllegalStateException("More than one child found: " + childTagName);
            }
            matched = childElem;
        }
        return matched;
    }

    public static String getChildTextContent(Element element, String childTagName) {
        Element childElem = XmlUtils.getChildElementByTagName(element, childTagName);
        return childElem == null ? null : childElem.getTextContent();
    }

    @Deprecated
    public static String toString(Document document) throws TransformerException {
        return XmlUtils.toString((Node)document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(Node node) throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (TransformerConfigurationException e) {
            throw new AssertionError("All implementations are required to support the javax.xml.XMLConstants.FEATURE_SECURE_PROCESSING feature.", e);
        }
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        transformerFactory.setAttribute("indent-number", 2);
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", StandardCharsets.UTF_8.name());
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", Integer.toString(2));
        StringWriter writer = new StringWriter();
        try {
            transformer.transform(new DOMSource(node), new StreamResult(writer));
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException e) {
                throw new AssertionError("IOException should never be thrown from StringWriter", e);
            }
        }
        return writer.toString();
    }

    public static boolean isNameStartChar(int codePoint) {
        return codePoint == 58 || codePoint >= 65 && codePoint <= 90 || codePoint == 95 || codePoint >= 97 && codePoint <= 122 || codePoint >= 192 && codePoint <= 214 || codePoint >= 216 && codePoint <= 246 || codePoint >= 248 && codePoint <= 767 || codePoint >= 880 && codePoint <= 893 || codePoint >= 895 && codePoint <= 8191 || codePoint >= 8204 && codePoint <= 8205 || codePoint >= 8304 && codePoint <= 8591 || codePoint >= 11264 && codePoint <= 12271 || codePoint >= 12289 && codePoint <= 55295 || codePoint >= 63744 && codePoint <= 64975 || codePoint >= 65008 && codePoint <= 65533 || codePoint >= 65536 && codePoint <= 983039;
    }

    public static boolean isNameChar(int codePoint) {
        return XmlUtils.isNameStartChar(codePoint) || codePoint == 45 || codePoint == 46 || codePoint >= 48 && codePoint <= 57 || codePoint == 183 || codePoint >= 768 && codePoint <= 879 || codePoint >= 8255 && codePoint <= 8256;
    }

    public static boolean isValidName(String name, int begin, int end) {
        if (name == null) {
            return false;
        }
        if (begin >= end) {
            return false;
        }
        int pos = begin;
        int codePoint = name.codePointAt(pos);
        pos += Character.charCount(codePoint);
        if (!XmlUtils.isNameStartChar(codePoint)) {
            return false;
        }
        while (pos < end) {
            codePoint = name.codePointAt(pos);
            pos += Character.charCount(codePoint);
            if (XmlUtils.isNameChar(codePoint)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidName(String name) {
        return name != null && XmlUtils.isValidName(name, 0, name.length());
    }

    @Deprecated
    public static boolean isValidId(String id) {
        return XmlUtils.isValidName(id);
    }

    public static boolean isHyphen(int codePoint) {
        return codePoint == 45 || codePoint == 126 || codePoint == 1418 || codePoint == 1470 || codePoint == 5120 || codePoint == 6150 || codePoint >= 8208 && codePoint <= 8213 || codePoint == 8275 || codePoint == 8315 || codePoint == 8331 || codePoint == 8722 || codePoint == 11799 || codePoint == 12316 || codePoint == 12336 || codePoint == 12448 || codePoint == 65073 || codePoint == 65074 || codePoint == 65112 || codePoint == 65123 || codePoint == 65293;
    }

    public static StringBuilder generateId(String template, String defaultId) {
        StringBuilder id;
        int pos;
        int codePoint;
        NullArgumentException.checkNotNull(template, "template");
        NullArgumentException.checkNotNull(defaultId, "defaultId");
        assert (XmlUtils.isValidName(defaultId));
        int len = template.length();
        for (pos = 0; pos < len && !XmlUtils.isNameStartChar(codePoint = template.codePointAt(pos)); pos += Character.charCount(codePoint)) {
        }
        if (pos == len) {
            id = new StringBuilder(defaultId);
        } else {
            id = new StringBuilder(len - pos);
            int lastCodePoint = Integer.MIN_VALUE;
            while (pos < len) {
                int codePoint2 = template.codePointAt(pos);
                pos += Character.charCount(codePoint2);
                if (XmlUtils.isNameChar(codePoint2) && codePoint2 != 45) {
                    id.appendCodePoint(codePoint2);
                    lastCodePoint = codePoint2;
                    continue;
                }
                if (!Character.isWhitespace(codePoint2) && !XmlUtils.isHyphen(codePoint2) || XmlUtils.isHyphen(lastCodePoint)) continue;
                id.append('-');
                lastCodePoint = 45;
            }
            int trimLen = id.length();
            while (trimLen > 1 && XmlUtils.isHyphen(id.charAt(trimLen - 1))) {
                id.setLength(--trimLen);
            }
        }
        assert (XmlUtils.isValidName(id.toString()));
        return id;
    }
}

