/*
 * Decompiled with CFR 0.152.
 */
package com.aoapps.lang.zip;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;

public class CorrectedGZIPInputStream
extends GZIPInputStream {
    private final FoundErrorLock foundErrorLock = new FoundErrorLock();
    private boolean foundError;

    public CorrectedGZIPInputStream(InputStream in) throws IOException {
        super(in);
    }

    public CorrectedGZIPInputStream(InputStream in, int size) throws IOException {
        super(in, size);
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        FoundErrorLock foundErrorLock = this.foundErrorLock;
        synchronized (foundErrorLock) {
            if (this.foundError) {
                return -1;
            }
            try {
                return super.read(buf, off, len);
            }
            catch (IOException err) {
                String message = err.getMessage();
                if (message.contains("Corrupt GZIP trailer")) {
                    this.foundError = true;
                    return -1;
                }
                throw err;
            }
        }
    }

    private static class FoundErrorLock {
        private FoundErrorLock() {
        }
    }
}

