/*
 * Decompiled with CFR 0.152.
 */
package com.aoapps.tempfiles;

import com.aoapps.tempfiles.TempFileContext;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.concurrent.atomic.AtomicReference;

public class TempFile
implements Closeable {
    private final Long contextId;
    private final AtomicReference<File> file;
    private final boolean isDirectory;

    TempFile(Long contextId, File file, boolean isDirectory) {
        this.contextId = contextId;
        this.file = new AtomicReference<File>(file);
        this.isDirectory = isDirectory;
    }

    public File getFile() throws IllegalStateException {
        File f = this.file.get();
        if (f == null) {
            throw new IllegalStateException("Temp file closed");
        }
        return f;
    }

    static void deleteRecursive(File file) throws IOException {
        Path deleteMe = file.toPath();
        Files.walkFileTree(deleteMe, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                if (exc != null) {
                    throw exc;
                }
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
        assert (!Files.exists(deleteMe, LinkOption.NOFOLLOW_LINKS));
    }

    @Override
    public void close() throws IOException {
        File f = this.file.getAndSet(null);
        if (f != null) {
            TempFileContext.removeDeleteOnExit(this.contextId, f.getName());
            if (f.exists()) {
                if (this.isDirectory) {
                    TempFile.deleteRecursive(f);
                } else {
                    Files.delete(f.toPath());
                }
            }
        }
    }
}

