/*
 * Decompiled with CFR 0.152.
 */
package com.aoapps.tempfiles;

import com.aoapps.tempfiles.TempFile;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TempFileContext
implements Closeable {
    private static final Logger logger = Logger.getLogger(TempFileContext.class.getName());
    private static final int MIN_PREFIX_LENGTH = 3;
    private static final int MAX_PREFIX_LENGTH = 64;
    private static final AtomicInteger activeCount = new AtomicInteger();
    private static final ConcurrentMap<Long, Map<String, DeleteMe>> deleteOnExits = new ConcurrentHashMap<Long, Map<String, DeleteMe>>();
    private static volatile Thread shutdownHook;
    private static final AtomicReference<File> systemTmpDir;
    private static final AtomicLong idGenerator;
    private final Long id;
    private final File tmpDir;
    private final AtomicBoolean closed;

    private static File getSystemTmpDir() {
        File tmpDir = systemTmpDir.get();
        if (tmpDir == null) {
            tmpDir = new File(System.getProperty("java.io.tmpdir"));
            if (systemTmpDir.compareAndSet(null, tmpDir)) {
                if (!tmpDir.exists()) {
                    try {
                        Files.createDirectories(tmpDir.toPath(), new FileAttribute[0]);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException("System temp directory does not exist and cannot be created: " + tmpDir, e);
                    }
                } else {
                    if (!tmpDir.exists()) {
                        throw new UncheckedIOException(new IOException("System temp directory does not exist: " + tmpDir));
                    }
                    if (!tmpDir.isDirectory()) {
                        throw new UncheckedIOException(new IOException("System temp directory is not a directory: " + tmpDir));
                    }
                    if (!tmpDir.canWrite()) {
                        throw new UncheckedIOException(new IOException("System temp directory is not writable: " + tmpDir));
                    }
                    if (!tmpDir.canRead()) {
                        throw new UncheckedIOException(new IOException("System temp directory is not readable: " + tmpDir));
                    }
                }
            } else {
                tmpDir = systemTmpDir.get();
            }
        }
        return tmpDir;
    }

    public TempFileContext(File tmpDir) {
        block7: {
            this.id = idGenerator.getAndIncrement();
            this.closed = new AtomicBoolean();
            File file = this.tmpDir = tmpDir == null ? TempFileContext.getSystemTmpDir() : tmpDir;
            assert (activeCount.get() >= 0);
            int newActiveCount = activeCount.incrementAndGet();
            if (newActiveCount < 0) {
                activeCount.decrementAndGet();
                throw new IllegalStateException("activeCount integer wraparound detected");
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "activeCount={0}", newActiveCount);
            }
            if (newActiveCount == 1) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Registering shutdown hook");
                }
                shutdownHook = new Thread(() -> {
                    Iterator iterator = deleteOnExits.values().iterator();
                    while (iterator.hasNext()) {
                        Map deleteMap;
                        Map map = deleteMap = (Map)iterator.next();
                        synchronized (map) {
                            for (DeleteMe deleteMe : deleteMap.values()) {
                                File f = deleteMe.file;
                                boolean isDirectory = deleteMe.isDirectory;
                                try {
                                    if (!f.exists()) continue;
                                    if (isDirectory) {
                                        TempFile.deleteRecursive(f);
                                        continue;
                                    }
                                    Files.delete(f.toPath());
                                }
                                catch (Throwable t) {
                                    if (!logger.isLoggable(Level.WARNING)) continue;
                                    logger.log(Level.WARNING, "Unable to delete " + (isDirectory ? "directory" : "file") + " on shutdown: " + f, t);
                                }
                            }
                        }
                    }
                });
                try {
                    Runtime.getRuntime().addShutdownHook(shutdownHook);
                }
                catch (IllegalArgumentException | IllegalStateException | SecurityException e) {
                    if (!logger.isLoggable(Level.WARNING)) break block7;
                    logger.log(Level.WARNING, "Failed to add shutdown hook", e);
                }
            }
        }
    }

    public TempFileContext(String tmpDir) {
        this(tmpDir == null ? null : new File(tmpDir));
    }

    public TempFileContext() {
        this((File)null);
    }

    public File getTmpDir() {
        return this.tmpDir;
    }

    public static String generatePrefix(String template) throws IOException {
        if (template == null || template.isEmpty()) {
            return "tmp_";
        }
        int len = Math.min(template.length(), 64);
        StringBuilder prefix = new StringBuilder(Math.min(len, 3));
        for (int i = 0; i < len; ++i) {
            int ch = template.charAt(i);
            prefix.append((char)(ch >= 97 && ch <= 122 || ch >= 65 && ch <= 90 || ch >= 48 && ch <= 57 || ch == 46 || ch == 45 || ch == 95 ? ch : 95));
        }
        while (prefix.length() < 3) {
            prefix.append('_');
        }
        return prefix.toString();
    }

    private static String formatPrefix(String prefix) {
        if (prefix == null || prefix.isEmpty()) {
            prefix = "tmp_";
        } else if (prefix.length() > 64) {
            prefix = prefix.substring(0, 64);
        } else {
            while (prefix.length() < 3) {
                prefix = prefix + '_';
            }
        }
        return prefix;
    }

    public TempFile createTempDirectory(String prefix) throws IllegalStateException, IOException {
        if (this.closed.get()) {
            throw new IllegalStateException("TempFiles is closed");
        }
        Path tmpPath;
        File tmpFile;
        while (!TempFileContext.addDeleteOnExit(this.id, tmpFile = (tmpPath = Files.createTempDirectory(this.tmpDir.toPath(), TempFileContext.formatPrefix(prefix), new FileAttribute[0])).toFile(), true)) {
            Files.delete(tmpPath);
        }
        return new TempFile(this.id, tmpFile, true);
    }

    public TempFile createTempDirectory() throws IllegalStateException, IOException {
        return this.createTempDirectory(null);
    }

    public TempFile createTempFile(String prefix, String suffix) throws IllegalStateException, IOException {
        if (this.closed.get()) {
            throw new IllegalStateException("TempFiles is closed");
        }
        Path tmpPath;
        File tmpFile;
        while (!TempFileContext.addDeleteOnExit(this.id, tmpFile = (tmpPath = Files.createTempFile(this.tmpDir.toPath(), TempFileContext.formatPrefix(prefix), suffix, new FileAttribute[0])).toFile(), false)) {
            Files.delete(tmpPath);
        }
        return new TempFile(this.id, tmpFile, false);
    }

    public TempFile createTempFile(String name) throws IllegalStateException, IOException {
        String suffix;
        String prefix;
        if (name == null || name.isEmpty()) {
            prefix = null;
            suffix = null;
        } else {
            int len;
            int lastDot = len = name.length();
            for (int i = len - 1; i > 0; --i) {
                char ch = name.charAt(i);
                if (ch == '.') {
                    if (i == lastDot - 1) break;
                    lastDot = i;
                    continue;
                }
                if (!(ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == '_')) break;
            }
            if (lastDot == len) {
                prefix = name;
                suffix = null;
            } else {
                prefix = name.substring(lastDot) + '_';
                suffix = name.substring(lastDot);
            }
        }
        return this.createTempFile(prefix, suffix);
    }

    public TempFile createTempFile() throws IllegalStateException, IOException {
        return this.createTempFile(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean addDeleteOnExit(Long id, File tmpFile, boolean isDirectory) throws IOException {
        Map existing;
        Map<String, DeleteMe> deleteMap = (LinkedHashMap<String, DeleteMe>)deleteOnExits.get(id);
        if (deleteMap == null && (existing = (Map)deleteOnExits.putIfAbsent(id, deleteMap = new LinkedHashMap<String, DeleteMe>())) != null) {
            deleteMap = existing;
        }
        LinkedHashMap<String, DeleteMe> linkedHashMap = deleteMap;
        synchronized (linkedHashMap) {
            return deleteMap.putIfAbsent(tmpFile.getName(), new DeleteMe(tmpFile, isDirectory)) == null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeDeleteOnExit(Long id, String name) {
        Map deleteMap = (Map)deleteOnExits.get(id);
        if (deleteMap != null) {
            Map map = deleteMap;
            synchronized (map) {
                deleteMap.remove(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        Map deleteMap = (Map)deleteOnExits.get(this.id);
        if (deleteMap != null) {
            Map map = deleteMap;
            synchronized (map) {
                return deleteMap.size();
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        boolean alreadyClosed = this.closed.getAndSet(true);
        if (!alreadyClosed) {
            Map deleteMap;
            block24: {
                deleteMap = (Map)deleteOnExits.remove(this.id);
                assert (activeCount.get() > 0);
                int newActiveCount = activeCount.decrementAndGet();
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "activeCount={0}", newActiveCount);
                }
                if (newActiveCount == 0) {
                    Thread hook = shutdownHook;
                    assert (hook != null);
                    shutdownHook = null;
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Removing shutdown hook");
                    }
                    try {
                        Runtime.getRuntime().removeShutdownHook(hook);
                    }
                    catch (IllegalStateException illegalStateException) {
                    }
                    catch (SecurityException e) {
                        if (!logger.isLoggable(Level.WARNING)) break block24;
                        logger.log(Level.WARNING, "Failed to removing shutdown hook", e);
                    }
                }
            }
            if (deleteMap != null) {
                ArrayList<DeleteMe> failedDelete = null;
                ArrayList<Throwable> causes = null;
                Map map = deleteMap;
                synchronized (map) {
                    for (DeleteMe deleteMe : deleteMap.values()) {
                        File f = deleteMe.file;
                        try {
                            if (!f.exists()) continue;
                            if (deleteMe.isDirectory) {
                                TempFile.deleteRecursive(f);
                                continue;
                            }
                            Files.delete(f.toPath());
                        }
                        catch (Throwable t) {
                            if (failedDelete == null) {
                                failedDelete = new ArrayList<DeleteMe>();
                                causes = new ArrayList<Throwable>();
                            }
                            assert (causes != null);
                            failedDelete.add(deleteMe);
                            causes.add(t);
                        }
                    }
                }
                if (failedDelete != null) {
                    assert (causes != null);
                    if (failedDelete.size() == 1) {
                        DeleteMe failed = (DeleteMe)failedDelete.get(0);
                        throw new IOException("Unable to delete temporary " + (failed.isDirectory ? "directory" : "file") + ": " + failed.file, (Throwable)causes.get(0));
                    }
                    StringBuilder sb = new StringBuilder("Unable to delete temporary directories/files:");
                    for (DeleteMe failed : failedDelete) {
                        sb.append("\n    ").append(failed.file);
                    }
                    IOException ioExc = new IOException(sb.toString());
                    for (Throwable cause : causes) {
                        ioExc.addSuppressed(cause);
                    }
                    throw ioExc;
                }
            }
        }
    }

    static {
        systemTmpDir = new AtomicReference();
        idGenerator = new AtomicLong(1L);
    }

    private static class DeleteMe {
        private final File file;
        private final boolean isDirectory;

        private DeleteMe(File file, boolean isDirectory) {
            this.file = file;
            this.isDirectory = isDirectory;
        }
    }
}

