/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.web.page;

import java.util.Objects;

public class Author {
    private final String name;
    private final String href;
    private final String bookName;
    private final String page;

    public Author(String name, String href, String bookName, String page) {
        if (name != null && name.isEmpty()) {
            throw new IllegalArgumentException("empty name not allowed");
        }
        if (href != null && href.isEmpty()) {
            throw new IllegalArgumentException("empty href not allowed");
        }
        if (bookName != null && bookName.isEmpty()) {
            throw new IllegalArgumentException("empty book not allowed");
        }
        if (page != null && page.isEmpty()) {
            throw new IllegalArgumentException("empty page not allowed");
        }
        if (href != null) {
            if (bookName != null) {
                throw new IllegalArgumentException("book may not be provided when href provided");
            }
            if (page != null) {
                throw new IllegalArgumentException("page may not be provided when href provided");
            }
        } else {
            if (name == null && page == null) {
                throw new IllegalArgumentException("empty author, at least one of name, href, or page required");
            }
            if (page != null) {
                if (bookName == null) {
                    throw new IllegalArgumentException("page provided without book");
                }
            } else if (bookName != null) {
                throw new IllegalArgumentException("book provided without page");
            }
        }
        this.name = name;
        this.href = href;
        this.bookName = bookName;
        this.page = page;
    }

    public String toString() {
        if (this.name != null) {
            return this.name;
        }
        if (this.href != null) {
            return this.href;
        }
        assert (this.bookName != null);
        assert (this.page != null);
        if (this.bookName.equals("/")) {
            return this.page;
        }
        return this.bookName + this.page;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Author)) {
            return false;
        }
        Author o = (Author)obj;
        return Objects.equals(this.name, o.name) && Objects.equals(this.href, o.href) && Objects.equals(this.bookName, o.bookName) && Objects.equals(this.page, o.page);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.href, this.bookName, this.page);
    }

    public String getName() {
        return this.name;
    }

    public String getHref() {
        return this.href;
    }

    public String getBookName() {
        return this.bookName;
    }

    public String getPage() {
        return this.page;
    }
}

