/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.web.page;

import com.aoindustries.web.page.ElementWriter;
import com.aoindustries.web.page.Node;
import com.aoindustries.web.page.Page;
import java.util.Objects;

public abstract class Element
extends Node {
    private Page page;
    private String id;
    private Element parentElement;

    public static boolean isValidId(String id) {
        if (id == null) {
            return false;
        }
        int len = id.length();
        if (len == 0) {
            return false;
        }
        char ch = id.charAt(0);
        if (!(ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z')) {
            return false;
        }
        for (int i = 1; i < len; ++i) {
            if (ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9' || ch == ':' || ch == '_' || ch == '.' || ch == '-') continue;
            return false;
        }
        return true;
    }

    public static StringBuilder generateIdPrefix(String template, String prefix) {
        StringBuilder idPrefix;
        char ch;
        int pos;
        assert (Element.isValidId(prefix));
        int len = template.length();
        for (pos = 0; !(pos >= len || (ch = template.charAt(pos)) >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z'); ++pos) {
        }
        if (pos == len) {
            idPrefix = new StringBuilder(prefix);
        } else {
            idPrefix = new StringBuilder(len - pos);
            while (pos < len) {
                char ch2 = template.charAt(pos);
                ++pos;
                if (ch2 == ' ') {
                    idPrefix.append('-');
                    continue;
                }
                if (!(ch2 >= 'A' && ch2 <= 'Z' || ch2 >= 'a' && ch2 <= 'z' || ch2 >= '0' && ch2 <= '9' || ch2 == ':' || ch2 == '_' || ch2 == '.') && ch2 != '-') continue;
                if (ch2 >= 'A' && ch2 <= 'Z') {
                    ch2 = (char)(ch2 + 32);
                }
                idPrefix.append(ch2);
            }
        }
        assert (Element.isValidId(idPrefix.toString()));
        return idPrefix;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Element)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        Element other = (Element)obj;
        return this.page != null && this.id != null && this.page.equals(other.page) && this.id.equals(other.id);
    }

    public int hashCode() {
        int hash = Objects.hashCode(this.page);
        hash = hash * 31 + Objects.hashCode(this.id);
        return hash;
    }

    protected abstract String getDefaultIdPrefix();

    public abstract String getLinkCssClass();

    @Override
    public Element freeze() {
        super.freeze();
        return this;
    }

    public Page getPage() {
        return this.page;
    }

    void setPage(Page page) {
        this.checkNotFrozen();
        if (this.page != null) {
            throw new IllegalStateException("element already has a page: " + this);
        }
        this.page = page;
        assert (this.checkPageAndParentElement());
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.checkNotFrozen();
        if (this.id != null) {
            throw new IllegalStateException("id already set");
        }
        if (id != null && !id.isEmpty()) {
            if (!Element.isValidId(id)) {
                throw new IllegalArgumentException("Invalid id: " + id);
            }
            this.id = id;
            if (this.page != null) {
                this.page.onElementIdSet(this);
            }
        }
    }

    public Element getParentElement() {
        return this.parentElement;
    }

    private void setParentElement(Element parentElement) {
        this.checkNotFrozen();
        if (this.parentElement != null) {
            throw new IllegalStateException("parentElement already set");
        }
        this.parentElement = parentElement;
        assert (this.checkPageAndParentElement());
    }

    private boolean checkPageAndParentElement() {
        if (this.page != null && this.parentElement != null && !this.page.equals(this.parentElement.page)) {
            throw new IllegalArgumentException("parentElement is not on the same page");
        }
        return true;
    }

    @Override
    public Long addChildElement(Element childElement, ElementWriter elementWriter) {
        Long elementKey = super.addChildElement(childElement, elementWriter);
        childElement.setParentElement(this);
        return elementKey;
    }
}

