/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.web.page;

import com.aoindustries.io.buffer.BufferResult;
import com.aoindustries.io.buffer.EmptyResult;
import com.aoindustries.web.page.Element;
import com.aoindustries.web.page.ElementWriter;
import com.aoindustries.web.page.Freezable;
import com.aoindustries.web.page.FrozenException;
import com.aoindustries.web.page.PageRef;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class Node
implements Freezable<Node> {
    private static final SecureRandom random = new SecureRandom();
    private boolean frozen;
    private List<Element> childElements;
    private Map<Long, ElementWriter> elementWriters;
    private Set<PageRef> files;
    private Set<PageRef> pageLinks;
    private BufferResult body;

    public String toString() {
        return this.getLabel();
    }

    @Override
    public Node freeze() {
        this.frozen = true;
        return this;
    }

    protected void checkNotFrozen() throws FrozenException {
        if (this.frozen) {
            throw new FrozenException();
        }
    }

    public List<Element> getChildElements() {
        if (this.childElements == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.childElements);
    }

    public Long addChildElement(Element childElement, ElementWriter elementWriter) {
        Long elementKey;
        this.checkNotFrozen();
        if (this.childElements == null) {
            this.childElements = new ArrayList<Element>();
        }
        this.childElements.add(childElement);
        if (this.elementWriters == null) {
            this.elementWriters = new HashMap<Long, ElementWriter>();
        }
        while (this.elementWriters.containsKey(elementKey = Long.valueOf(random.nextLong()))) {
        }
        this.elementWriters.put(elementKey, elementWriter);
        return elementKey;
    }

    ElementWriter getElementWriter(long elementKey) {
        return this.elementWriters == null ? null : this.elementWriters.get(elementKey);
    }

    public Set<PageRef> getFiles() {
        if (this.files == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.files);
    }

    public void addFile(PageRef file) {
        this.checkNotFrozen();
        if (this.files == null) {
            this.files = new LinkedHashSet<PageRef>();
        }
        this.files.add(file);
    }

    public Set<PageRef> getPageLinks() {
        if (this.pageLinks == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.pageLinks);
    }

    public void addPageLink(PageRef pageLink) {
        this.checkNotFrozen();
        if (this.pageLinks == null) {
            this.pageLinks = new LinkedHashSet<PageRef>();
        }
        this.pageLinks.add(pageLink);
    }

    public BufferResult getBody() {
        if (this.body == null) {
            return EmptyResult.getInstance();
        }
        return this.body;
    }

    public void setBody(BufferResult body) {
        this.checkNotFrozen();
        try {
            assert (body.getLength() == body.trim().getLength()) : "body must have already been trimmed";
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        this.body = body;
    }

    public String getLabel() {
        StringBuilder sb = new StringBuilder();
        try {
            this.appendLabel(sb);
        }
        catch (IOException e) {
            throw new AssertionError("Should not happen because using StringBuilder", e);
        }
        return sb.toString();
    }

    public void appendLabel(Appendable out) throws IOException {
        out.append(this.getLabel());
    }

    public abstract String getListItemCssClass();
}

