/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.web.page;

import com.aoindustries.util.AoCollections;
import com.aoindustries.web.page.Author;
import com.aoindustries.web.page.Copyright;
import com.aoindustries.web.page.PageRef;
import java.io.File;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class Book
implements Comparable<Book> {
    private static final String PARAM_PREFIX = "param.";
    private final String name;
    private final String pathPrefix;
    private final File cvsworkDirectory;
    private final Set<PageRef> unmodifiableParentPages;
    private final PageRef contentRoot;
    private final Copyright copyright;
    private final Set<Author> unmodifiableAuthors;
    private final String title;
    private final String pageHeader;
    private final int navigationFrameWidth;
    private final String logoSrc;
    private final int logoWidth;
    private final int logoHeight;
    private final String logoAlt;
    private final Map<String, String> unmodifiableParam;

    private static String getProperty(Properties bookProps, Set<Object> usedKeys, String key) {
        usedKeys.add(key);
        return bookProps.getProperty(key);
    }

    public Book(String name, String cvsworkDirectory, Set<PageRef> parentPages, Properties bookProps) {
        if (!name.startsWith("/")) {
            throw new IllegalArgumentException("Book name must begin with a slash (/): " + name);
        }
        HashSet<Object> usedKeys = new HashSet<Object>(bookProps.size() * 4 / 3 + 1);
        this.name = name;
        this.pathPrefix = "/".equals(name) ? "" : name;
        this.cvsworkDirectory = cvsworkDirectory.startsWith("~/") ? new File(System.getProperty("user.home"), cvsworkDirectory.substring(2)) : new File(cvsworkDirectory);
        this.unmodifiableParentPages = AoCollections.optimalUnmodifiableSet(parentPages);
        String copyrightRightsHolder = Book.getProperty(bookProps, usedKeys, "copyright.rightsHolder");
        String copyrightRights = Book.getProperty(bookProps, usedKeys, "copyright.rights");
        String copyrightDateCopyrighted = Book.getProperty(bookProps, usedKeys, "copyright.dateCopyrighted");
        this.copyright = copyrightRightsHolder != null || copyrightRights != null || copyrightDateCopyrighted != null ? new Copyright(copyrightRightsHolder != null ? copyrightRightsHolder : "", copyrightRights != null ? copyrightRights : "", copyrightDateCopyrighted != null ? copyrightDateCopyrighted : "") : null;
        LinkedHashSet<Author> authors = new LinkedHashSet<Author>();
        for (int i = 1; i < Integer.MAX_VALUE; ++i) {
            String authorName = Book.getProperty(bookProps, usedKeys, "author." + i + ".name");
            String authorHref = Book.getProperty(bookProps, usedKeys, "author." + i + ".href");
            String authorBook = Book.getProperty(bookProps, usedKeys, "author." + i + ".book");
            String authorPage = Book.getProperty(bookProps, usedKeys, "author." + i + ".page");
            if (authorName == null && authorHref == null && authorBook == null && authorPage == null) break;
            if (authorPage != null && authorBook == null) {
                authorBook = name;
            }
            if (authorName == null && authorBook != null && !authorBook.equals(name)) {
                throw new IllegalStateException(name + ": Author name required when author is in a different book: " + authorPage);
            }
            Author newAuthor = new Author(authorName, authorHref, authorBook, authorPage);
            if (authors.add(newAuthor)) continue;
            throw new IllegalStateException(name + ": Duplicate author: " + newAuthor);
        }
        this.unmodifiableAuthors = AoCollections.optimalUnmodifiableSet(authors);
        this.title = Book.getProperty(bookProps, usedKeys, "title");
        this.pageHeader = Book.getProperty(bookProps, usedKeys, "pageHeader");
        this.navigationFrameWidth = Integer.parseInt(Book.getProperty(bookProps, usedKeys, "navigationFrameWidth"));
        this.logoSrc = Book.getProperty(bookProps, usedKeys, "logoSrc");
        this.logoWidth = Integer.parseInt(Book.getProperty(bookProps, usedKeys, "logoWidth"));
        this.logoHeight = Integer.parseInt(Book.getProperty(bookProps, usedKeys, "logoHeight"));
        this.logoAlt = Book.getProperty(bookProps, usedKeys, "logoAlt");
        LinkedHashMap<String, String> newParam = new LinkedHashMap<String, String>();
        Enumeration<?> propertyNames = bookProps.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String propertyName = (String)propertyNames.nextElement();
            if (!propertyName.startsWith(PARAM_PREFIX)) continue;
            newParam.put(propertyName.substring(PARAM_PREFIX.length()), Book.getProperty(bookProps, usedKeys, propertyName));
        }
        this.unmodifiableParam = AoCollections.optimalUnmodifiableMap(newParam);
        this.contentRoot = new PageRef(this, Book.getProperty(bookProps, usedKeys, "content.root"));
        HashSet<Object> unusedKeys = new HashSet<Object>();
        for (Object key : bookProps.keySet()) {
            if (usedKeys.contains(key)) continue;
            unusedKeys.add(key);
        }
        if (!unusedKeys.isEmpty()) {
            throw new IllegalStateException(name + ": Unused keys: " + unusedKeys);
        }
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Book)) {
            return false;
        }
        Book other = (Book)obj;
        return this.name.equals(other.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public int compareTo(Book o) {
        return this.name.compareTo(o.name);
    }

    public String getName() {
        return this.name;
    }

    public String getPathPrefix() {
        return this.pathPrefix;
    }

    public File getCvsworkDirectory() {
        return this.cvsworkDirectory;
    }

    public Set<PageRef> getParentPages() {
        return this.unmodifiableParentPages;
    }

    public PageRef getContentRoot() {
        return this.contentRoot;
    }

    public Copyright getCopyright() {
        assert (this.copyright == null || !this.copyright.isEmpty());
        return this.copyright;
    }

    public Set<Author> getAuthors() {
        return this.unmodifiableAuthors;
    }

    public String getTitle() {
        return this.title;
    }

    public String getPageHeader() {
        return this.pageHeader;
    }

    public int getNavigationFrameWidth() {
        return this.navigationFrameWidth;
    }

    public String getLogoSrc() {
        return this.logoSrc;
    }

    public int getLogoWidth() {
        return this.logoWidth;
    }

    public int getLogoHeight() {
        return this.logoHeight;
    }

    public String getLogoAlt() {
        return this.logoAlt;
    }

    public Map<String, String> getParam() {
        return this.unmodifiableParam;
    }
}

