/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.web.page;

import com.aoindustries.lang.ObjectUtils;

public class Copyright {
    private final String rightsHolder;
    private final String rights;
    private final String dateCopyrighted;

    public Copyright(String rightsHolder, String rights, String dateCopyrighted) {
        if (rightsHolder == null && rights == null && dateCopyrighted == null) {
            throw new IllegalArgumentException("At least one of rightsHolder, rights, or dateCopyrighted required");
        }
        this.rightsHolder = rightsHolder;
        this.rights = rights;
        this.dateCopyrighted = dateCopyrighted;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "No copyright";
        }
        StringBuilder copy = new StringBuilder();
        copy.append("Copyright \u00a9");
        if (this.dateCopyrighted != null && !this.dateCopyrighted.isEmpty()) {
            copy.append(' ').append(this.dateCopyrighted).append('.');
        }
        if (this.rightsHolder != null && !this.rightsHolder.isEmpty()) {
            copy.append(' ').append(this.rightsHolder).append('.');
        }
        if (this.rights != null && !this.rights.isEmpty()) {
            copy.append(' ').append(this.rights).append('.');
        }
        return copy.toString();
    }

    private boolean equals(String otherRightsHolder, String otherRights, String otherDateCopyrighted) {
        return ObjectUtils.equals((Object)this.rightsHolder, (Object)otherRightsHolder) && ObjectUtils.equals((Object)this.rights, (Object)otherRights) && ObjectUtils.equals((Object)this.dateCopyrighted, (Object)otherDateCopyrighted);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Copyright)) {
            return false;
        }
        Copyright o = (Copyright)obj;
        return this.equals(o.rightsHolder, o.rights, o.dateCopyrighted);
    }

    public int hashCode() {
        return ObjectUtils.hash((Object[])new Object[]{this.rightsHolder, this.rights, this.dateCopyrighted});
    }

    public String getRightsHolder() {
        return this.rightsHolder;
    }

    public String getRights() {
        return this.rights;
    }

    public String getDateCopyrighted() {
        return this.dateCopyrighted;
    }

    public boolean hasAllFields() {
        return this.rightsHolder != null && this.rights != null && this.dateCopyrighted != null;
    }

    public boolean isEmpty() {
        return !(this.rightsHolder != null && !this.rightsHolder.isEmpty() || this.rights != null && !this.rights.isEmpty() || this.dateCopyrighted != null && !this.dateCopyrighted.isEmpty());
    }
}

