/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.web.page;

import com.aoindustries.util.StringUtility;
import com.aoindustries.web.page.ElementContext;
import com.aoindustries.web.page.ElementWriter;
import com.aoindustries.web.page.Node;
import java.io.IOException;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NodeBodyWriter
extends Writer {
    private static final Logger logger = Logger.getLogger(NodeBodyWriter.class.getName());
    static final String MARKER_PREFIX = "<A<O<ELEMENT ";
    private static final int MARKER_PREFIX_LEN = "<A<O<ELEMENT ".length();
    private static final char[] MARKER_PREFIX_CHARS = "<A<O<ELEMENT ".toCharArray();
    static final String MARKER_SUFFIX = ">O>A>";
    private static final int MARKER_SUFFIX_LEN = ">O>A>".length();
    private static final char[] MARKER_SUFFIX_CHARS = ">O>A>".toCharArray();
    private static final int ELEMENT_KEY_LEN = 16;
    private final Node node;
    private final Writer out;
    private final ElementContext context;
    private final char[] elementKeyBuffer = new char[16];
    private int markerPos = 0;

    public static void writeElementMarker(long elementKey, Appendable out) throws IOException {
        out.append(MARKER_PREFIX);
        StringUtility.convertToHex((long)elementKey, (Appendable)out);
        out.append(MARKER_SUFFIX);
    }

    public NodeBodyWriter(Node node, Writer out, ElementContext context) {
        this.node = node;
        this.out = out;
        this.context = context;
    }

    private void writeCharsToOut(char[] cbuf, int len) throws IOException {
        if (len > 0) {
            if (len == 1) {
                this.out.write(cbuf[0]);
            } else {
                this.out.write(cbuf, 0, len);
            }
        }
    }

    @Override
    public void write(int c) throws IOException {
        while (true) {
            if (this.markerPos < MARKER_PREFIX_LEN) {
                if ((char)c == MARKER_PREFIX_CHARS[this.markerPos]) {
                    ++this.markerPos;
                    return;
                }
                if (this.markerPos > 0) {
                    this.writeCharsToOut(MARKER_PREFIX_CHARS, this.markerPos);
                    this.markerPos = 0;
                    continue;
                }
                this.out.write(c);
                return;
            }
            if (this.markerPos < MARKER_PREFIX_LEN + 16) {
                int elementKeyPos = this.markerPos - MARKER_PREFIX_LEN;
                if (c >= 48 && c <= 57 || c >= 97 && c <= 102) {
                    this.elementKeyBuffer[elementKeyPos] = (char)c;
                    ++this.markerPos;
                    return;
                }
                this.out.write(MARKER_PREFIX_CHARS, 0, MARKER_PREFIX_LEN);
                this.writeCharsToOut(this.elementKeyBuffer, elementKeyPos);
                this.markerPos = 0;
                continue;
            }
            int markerSuffixPos = this.markerPos - (MARKER_PREFIX_LEN + 16);
            if ((char)c == MARKER_SUFFIX_CHARS[markerSuffixPos]) {
                ++this.markerPos;
                if (this.markerPos == MARKER_PREFIX_LEN + 16 + MARKER_SUFFIX_LEN) {
                    long elementKey = StringUtility.convertLongArrayFromHex((char[])this.elementKeyBuffer);
                    ElementWriter elementWriter = this.node.getElementWriter(elementKey);
                    if (elementWriter != null) {
                        elementWriter.writeTo(this.out, this.context);
                    } else {
                        if (logger.isLoggable(Level.WARNING)) {
                            logger.warning("ElementWriter not found by key: " + String.valueOf(this.elementKeyBuffer) + " in " + this.node);
                        }
                        this.out.write(MARKER_PREFIX_CHARS, 0, MARKER_PREFIX_LEN);
                        this.out.write(this.elementKeyBuffer, 0, 16);
                        this.out.write(MARKER_SUFFIX_CHARS, 0, MARKER_SUFFIX_LEN);
                    }
                    this.markerPos = 0;
                }
                return;
            }
            this.out.write(MARKER_PREFIX_CHARS, 0, MARKER_PREFIX_LEN);
            this.out.write(this.elementKeyBuffer, 0, 16);
            this.writeCharsToOut(this.elementKeyBuffer, markerSuffixPos);
            this.markerPos = 0;
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        while (len > 0) {
            this.write(cbuf[off]);
            ++off;
            --len;
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.markerPos > 0) {
            this.writeCharsToOut(MARKER_PREFIX_CHARS, Math.min(this.markerPos, MARKER_PREFIX_LEN));
            this.writeCharsToOut(this.elementKeyBuffer, Math.min(this.markerPos - MARKER_PREFIX_LEN, 16));
            this.writeCharsToOut(MARKER_SUFFIX_CHARS, this.markerPos - (MARKER_PREFIX_LEN + 16));
            this.markerPos = 0;
            this.out.flush();
        }
        this.out.close();
    }
}

