/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.web.page;

import com.aoindustries.util.AoCollections;
import com.aoindustries.web.page.Author;
import com.aoindustries.web.page.Copyright;
import com.aoindustries.web.page.Element;
import com.aoindustries.web.page.Heading;
import com.aoindustries.web.page.Node;
import com.aoindustries.web.page.PageRef;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Page
extends Node {
    public static final int MIN_TOC_LEVELS = 1;
    public static final int MAX_TOC_LEVELS = 5;
    public static final int DEFAULT_TOC_LEVELS = 3;
    private PageRef pageRef;
    private PageRef src;
    private Copyright copyright;
    private Set<Author> authors;
    private String title;
    private String shortTitle;
    private String description;
    private String keywords;
    private Boolean toc;
    private int tocLevels = 3;
    private Set<PageRef> parentPages;
    private boolean allowParentMismatch;
    private Set<PageRef> childPages;
    private boolean allowChildMismatch;
    private List<Element> elements;
    private Map<String, Element> elementsById;
    private List<Heading> topLevelHeadings;

    public boolean equals(Object obj) {
        if (!(obj instanceof Page)) {
            return false;
        }
        return this.pageRef.equals(((Page)obj).pageRef);
    }

    public int hashCode() {
        return this.pageRef.hashCode();
    }

    @Override
    public Page freeze() {
        if (this.elements != null && (this.elementsById == null || this.elements.size() > this.elementsById.size())) {
            block0: for (Element element : this.elements) {
                String id = element.getId();
                if (id != null) continue;
                StringBuilder possId = Element.generateIdPrefix(element.getLabel(), element.getDefaultIdPrefix());
                int possIdLen = possId.length();
                for (int i = 1; i <= Integer.MAX_VALUE; ++i) {
                    if (i == Integer.MAX_VALUE) {
                        throw new IllegalStateException("ID not generated");
                    }
                    if (i > 1) {
                        possId.append('-').append(i);
                    }
                    String newId = possId.toString();
                    if (this.elementsById == null || !this.elementsById.containsKey(newId)) {
                        element.setId(newId);
                        element.freeze();
                        continue block0;
                    }
                    possId.setLength(possIdLen);
                }
            }
            assert (this.elementsById != null);
            assert (this.elements.size() == this.elementsById.size()) : "elements and elementsById are different size: " + this.elements.size() + " != " + this.elementsById.size();
        }
        super.freeze();
        return this;
    }

    public PageRef getPageRef() {
        return this.pageRef;
    }

    public void setPageRef(PageRef pageRef) {
        this.checkNotFrozen();
        this.pageRef = pageRef;
    }

    public PageRef getSrc() {
        return this.src;
    }

    public void setSrc(PageRef src) {
        this.checkNotFrozen();
        this.src = src;
    }

    public Copyright getCopyright() {
        return this.copyright;
    }

    public void setCopyright(Copyright copyright) {
        this.checkNotFrozen();
        this.copyright = copyright;
    }

    public Set<Author> getAuthors() {
        if (this.authors == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.authors);
    }

    public void addAuthor(Author author) {
        this.checkNotFrozen();
        if (this.authors == null) {
            this.authors = new LinkedHashSet<Author>();
        }
        if (!this.authors.add(author)) {
            throw new IllegalStateException("Duplicate author: " + author);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.checkNotFrozen();
        this.title = title;
    }

    public String getShortTitle() {
        return this.shortTitle != null ? this.shortTitle : this.getTitle();
    }

    public void setShortTitle(String shortTitle) {
        this.checkNotFrozen();
        this.shortTitle = shortTitle;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.checkNotFrozen();
        this.description = description;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public void setKeywords(String keywords) {
        this.checkNotFrozen();
        this.keywords = keywords;
    }

    public Boolean getToc() {
        return this.toc;
    }

    public void setToc(Boolean toc) {
        this.checkNotFrozen();
        this.toc = toc;
    }

    public int getTocLevels() {
        return this.tocLevels;
    }

    public void setTocLevels(int tocLevels) {
        this.checkNotFrozen();
        if (tocLevels < 1 || tocLevels > 5) {
            throw new IllegalArgumentException("tocLevels must be between 1 and 5: " + tocLevels);
        }
        this.tocLevels = tocLevels;
    }

    public Set<PageRef> getParentPages() {
        if (this.parentPages == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.parentPages);
    }

    public void addParentPage(PageRef parentPage) {
        this.checkNotFrozen();
        if (this.parentPages == null) {
            this.parentPages = new LinkedHashSet<PageRef>();
        }
        if (!this.parentPages.add(parentPage)) {
            throw new IllegalStateException("Duplicate parent: " + parentPage);
        }
    }

    public boolean getAllowParentMismatch() {
        return this.allowParentMismatch;
    }

    public void setAllowParentMismatch(boolean allowParentMismatch) {
        this.checkNotFrozen();
        this.allowParentMismatch = allowParentMismatch;
    }

    public Set<PageRef> getChildPages() {
        if (this.childPages == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.childPages);
    }

    public void addChildPage(PageRef childPage) {
        this.checkNotFrozen();
        if (this.childPages == null) {
            this.childPages = new LinkedHashSet<PageRef>();
        }
        if (!this.childPages.add(childPage)) {
            throw new IllegalStateException("Duplicate child: " + childPage);
        }
    }

    public boolean getAllowChildMismatch() {
        return this.allowChildMismatch;
    }

    public void setAllowChildMismatch(boolean allowChildMismatch) {
        this.checkNotFrozen();
        this.allowChildMismatch = allowChildMismatch;
    }

    public List<Element> getElements() {
        if (this.elements == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.elements);
    }

    public <E extends Element> List<E> filterElements(Class<E> clazz) {
        if (this.elements == null) {
            return Collections.emptyList();
        }
        return AoCollections.filter(this.elements, clazz);
    }

    public Map<String, Element> getElementsById() {
        if (this.elementsById == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.elementsById);
    }

    public void addElement(Element element) {
        this.checkNotFrozen();
        element.setPage(this);
        if (this.elements == null) {
            this.elements = new ArrayList<Element>();
        }
        this.elements.add(element);
        this.addToElementsById(element);
    }

    private void addToElementsById(Element element) {
        String id = element.getId();
        if (id != null) {
            if (this.elementsById == null) {
                this.elementsById = new HashMap<String, Element>();
            }
            if (this.elementsById.put(id, element) != null) {
                throw new AssertionError((Object)("Duplicate id: " + id));
            }
        }
    }

    void onElementIdSet(Element element) {
        this.addToElementsById(element);
    }

    @Override
    public String getLabel() {
        return this.getShortTitle();
    }

    @Override
    public String getListItemCssClass() {
        return this.getChildPages().isEmpty() ? "ao-web-page-list-item-page-nochildren" : "ao-web-page-list-item-page-children";
    }

    public List<Heading> getTopLevelHeadings() {
        if (this.topLevelHeadings == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.topLevelHeadings);
    }

    public void addTopLevelHeading(Heading heading) {
        this.checkNotFrozen();
        if (this.topLevelHeadings == null) {
            this.topLevelHeadings = new ArrayList<Heading>();
        }
        this.topLevelHeadings.add(heading);
    }
}

