/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.web.page;

import com.aoindustries.lang.NullArgumentException;
import com.aoindustries.web.page.Book;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class PageRef {
    private final String bookName;
    private final String path;
    private final Book book;
    private int hash;
    private volatile String servletPath;
    private volatile File resourceFile;

    private PageRef(String bookName, String path, Book book) {
        this.bookName = (String)NullArgumentException.checkNotNull((Object)bookName, (String)"bookName");
        this.path = (String)NullArgumentException.checkNotNull((Object)path, (String)"path");
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("Path does not begin with a slash: " + path);
        }
        assert (book == null || book.getName().equals(bookName));
        this.book = book;
    }

    public PageRef(String bookName, String path) {
        this(bookName, path, null);
    }

    public PageRef(Book book, String path) {
        this(book.getName(), path, book);
    }

    public String getBookName() {
        return this.bookName;
    }

    public String getBookPrefix() {
        return "/".equals(this.bookName) ? "" : this.bookName;
    }

    public String getPath() {
        return this.path;
    }

    public PageRef setPath(String newPath) {
        return newPath.equals(this.path) ? this : new PageRef(this.bookName, newPath, this.book);
    }

    public Book getBook() {
        return this.book;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PageRef)) {
            return false;
        }
        PageRef other = (PageRef)obj;
        return this.bookName.equals(other.bookName) && this.path.equals(other.path);
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            h = this.bookName.hashCode();
            this.hash = h = h * 31 + this.path.hashCode();
        }
        return h;
    }

    public String getServletPath() {
        String sp = this.servletPath;
        if (sp == null) {
            this.servletPath = sp = "/".equals(this.bookName) ? this.path : this.bookName + this.path;
        }
        return sp;
    }

    public void appendServletPath(Appendable out) throws IOException {
        if (!"/".equals(this.bookName)) {
            out.append(this.bookName);
        }
        out.append(this.path);
    }

    public String toString() {
        return this.getServletPath();
    }

    public File getResourceFile(boolean requireBook, boolean requireFile) throws IOException {
        if (this.book == null) {
            if (requireBook) {
                throw new IOException("Book not found: " + this.bookName);
            }
            return null;
        }
        File rf = this.resourceFile;
        if (rf == null) {
            int end;
            File cvsworkDirectory = this.book.getCvsworkDirectory();
            assert (this.path.charAt(0) == '/');
            int start = 1;
            for (end = this.path.length(); end > start && this.path.charAt(end - 1) == '/'; --end) {
            }
            String subPath = this.path.substring(start, end);
            rf = subPath.isEmpty() ? cvsworkDirectory : new File(cvsworkDirectory, subPath);
            String canonicalPath = rf.getCanonicalPath();
            if (!canonicalPath.startsWith(cvsworkDirectory.getCanonicalPath() + File.separatorChar)) {
                throw new SecurityException();
            }
            if (requireFile && !rf.exists()) {
                throw new FileNotFoundException(rf.getPath());
            }
            this.resourceFile = rf;
        }
        return rf;
    }
}

