/*
 * Decompiled with CFR 0.152.
 */
package com.aparapi.natives;

import com.aparapi.natives.util.NativeUtils;
import java.io.IOException;

public class NativeLoader {
    private static final String ARCH = System.getProperty("os.arch").toLowerCase();
    private static final String OS = System.getProperty("os.name").toLowerCase();

    public static void load() throws IOException {
        if (NativeLoader.isUnix()) {
            if (NativeLoader.is64Bit()) {
                NativeUtils.loadLibraryFromJar("/linux/libaparapi_x86_64.so");
            } else {
                NativeUtils.loadLibraryFromJar("/linux/libaparapi_x86.so");
            }
        } else if (NativeLoader.isMac() && NativeLoader.is64Bit()) {
            NativeUtils.loadLibraryFromJar("/osx/libaparapi_x86_64.dylib");
        } else if (NativeLoader.isWindows() && NativeLoader.is64Bit()) {
            NativeUtils.loadLibraryFromJar("/win/libaparapi_x86_64.dll");
        } else if (NativeLoader.isWindows() && NativeLoader.is32Bit()) {
            NativeUtils.loadLibraryFromJar("/win/libaparapi_x86.dll");
        } else {
            throw new IOException("System is not compatable with any of the known native libraries.");
        }
    }

    private static boolean isWindows() {
        return OS.contains("win");
    }

    private static boolean isMac() {
        return OS.contains("mac");
    }

    private static boolean isUnix() {
        return OS.contains("nix") || OS.contains("nux") || OS.contains("aix");
    }

    private static boolean isSolaris() {
        return OS.contains("sunos");
    }

    private static boolean is64Bit() {
        return ARCH.contains("64");
    }

    private static boolean is32Bit() {
        return !NativeLoader.is64Bit();
    }
}

