/*
 * Decompiled with CFR 0.152.
 */
package com.aparzev.lang;

import java.lang.reflect.Array;
import java.util.ArrayList;

public class ArrayUtils
extends org.apache.commons.lang.ArrayUtils {
    public static boolean containsAll(int[] array1, int[] array2) {
        if (array1 == null) {
            throw new IllegalArgumentException("First array must not be null");
        }
        if (array2 == null) {
            throw new IllegalArgumentException("Second array must not be null");
        }
        for (int i = 0; i < array2.length; ++i) {
            int value = array2[i];
            if (ArrayUtils.contains((int[])array1, (int)value)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(Object[] array1, Object[] array2) {
        if (array1 == null) {
            throw new IllegalArgumentException("First array must not be null");
        }
        if (array2 == null) {
            throw new IllegalArgumentException("Second array must not be null");
        }
        for (int i = 0; i < array2.length; ++i) {
            Object value = array2[i];
            if (ArrayUtils.contains((Object[])array1, (Object)value)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(int[] array1, int[] array2) {
        if (array1 == null && array2 == null) {
            return true;
        }
        if (array1 == null || array2 == null) {
            return false;
        }
        return ArrayUtils.containsAll(array1, array2) && ArrayUtils.containsAll(array2, array1);
    }

    public static boolean equals(Object[] array1, Object[] array2) {
        if (array1 == null && array2 == null) {
            return true;
        }
        if (array1 == null || array2 == null) {
            return false;
        }
        return ArrayUtils.containsAll(array1, array2) && ArrayUtils.containsAll(array2, array1);
    }

    private static Object[] getArray(Class clazz, int length) {
        return (Object[])Array.newInstance(clazz.getComponentType(), length);
    }

    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static Object[] removeNulls(Object[] array) {
        if (array == null) {
            throw new NullPointerException("array argument must not be null");
        }
        ArrayList<Object> result = new ArrayList<Object>(array.length);
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) continue;
            result.add(array[i]);
        }
        Object[] a = ArrayUtils.getArray(array.getClass(), result.size());
        return result.toArray(a);
    }

    public static Object[] slice(Object[] src, int startPos) {
        if (src == null) {
            throw new NullPointerException("Source array must not be null");
        }
        if (startPos < 0 || startPos >= src.length) {
            throw new ArrayIndexOutOfBoundsException("Invalid start position: " + startPos);
        }
        Object[] dest = new Object[src.length - startPos];
        System.arraycopy(src, startPos, dest, 0, dest.length);
        return dest;
    }
}

