/*
 * Decompiled with CFR 0.152.
 */
package com.aparzev.lang;

import com.aparzev.lang.ArrayUtils;
import java.util.ArrayList;
import java.util.Collection;

public class StringUtils
extends org.apache.commons.lang.StringUtils {
    private static String[] regexEscapeStrings = new String[]{"\\", "[", "]", "(", ")", "{", "}", "^", ".", "|", "$", "*", "+", "?"};

    public static String escapeRegex(String regex, String[] exceptions) {
        if (regex == null) {
            throw new IllegalArgumentException("regex must not be null");
        }
        if (exceptions == null) {
            throw new IllegalArgumentException("exceptions must not be null");
        }
        for (int i = 0; i < regexEscapeStrings.length; ++i) {
            String escape = regexEscapeStrings[i];
            if (ArrayUtils.contains((Object[])exceptions, (Object)escape)) continue;
            regex = StringUtils.replace((String)regex, (String)escape, (String)("\\" + escape));
        }
        return regex;
    }

    public static String join(boolean[] array, String separator) {
        if (array == null) {
            return null;
        }
        Object[] result = new Boolean[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = new Boolean(array[i]);
        }
        return StringUtils.join((Object[])result, (String)separator);
    }

    public static String join(Collection collection, String separator) {
        if (collection == null) {
            return null;
        }
        return StringUtils.join(collection.iterator(), (String)separator);
    }

    public static String join(int[] array, String separator) {
        if (array == null) {
            return null;
        }
        Object[] result = new Integer[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = new Integer(array[i]);
        }
        return StringUtils.join((Object[])result, (String)separator);
    }

    public static String maskNull(String s, String mask) {
        return s == null ? mask : s;
    }

    public static String maskNullByEmpty(String s) {
        return StringUtils.maskNull(s, "");
    }

    public static String[] removeEmptyStrings(String[] array) {
        if (array == null) {
            throw new NullPointerException("array argument must not be null");
        }
        ArrayList<String> result = new ArrayList<String>(array.length);
        for (int i = 0; i < array.length; ++i) {
            if (StringUtils.isEmpty((String)array[i])) continue;
            result.add(array[i]);
        }
        return result.toArray(new String[result.size()]);
    }

    private StringUtils() {
    }
}

