/*
 * Decompiled with CFR 0.152.
 */
package com.aparzev.doka.ms.excel;

import com.aparzev.doka.ms.excel.DataTypeException;
import com.aparzev.doka.ms.excel.TypeDefinition;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import jxl.BooleanCell;
import jxl.Cell;
import jxl.CellType;
import jxl.DateCell;
import jxl.LabelCell;
import jxl.NumberCell;
import jxl.write.WritableCell;

public class CellValue {
    private Map dateValues = new HashMap();
    private TypeDefinition typeDef;
    private Object value;

    static CellValue createFromCell(Cell cell, TypeDefinition typeDef) throws DataTypeException {
        CellType cellType = cell.getType();
        if (typeDef.isStrict()) {
            Class requiredType = typeDef.getType();
            if (requiredType.equals(Date.class)) {
                if (cellType == CellType.DATE) {
                    DateCell c = (DateCell)cell;
                    return new CellValue(c.getDate(), typeDef);
                }
                throw new DataTypeException("Cell type " + cellType.toString() + " does not match the defined type " + typeDef.getType().getName());
            }
            if (requiredType.equals(String.class)) {
                return new CellValue(cell.getContents(), typeDef);
            }
            throw new DataTypeException("Cell type " + cellType.toString() + " does not match the defined type " + typeDef.getType().getName());
        }
        if (cellType == CellType.LABEL || cellType == CellType.STRING_FORMULA) {
            LabelCell c = (LabelCell)cell;
            return new CellValue(c.getString(), typeDef);
        }
        if (cellType == CellType.DATE || cellType == CellType.DATE_FORMULA) {
            DateCell c = (DateCell)cell;
            return new CellValue(c.getDate(), typeDef);
        }
        if (cellType == CellType.NUMBER || cellType == CellType.NUMBER_FORMULA) {
            NumberCell c = (NumberCell)cell;
            return new CellValue(new Double(c.getValue()), typeDef);
        }
        if (cellType == CellType.BOOLEAN || cellType == CellType.BOOLEAN_FORMULA) {
            BooleanCell c = (BooleanCell)cell;
            return new CellValue(new Boolean(c.getValue()), typeDef);
        }
        if (cellType == CellType.EMPTY) {
            return new CellValue(null, typeDef);
        }
        throw new DataTypeException("Unknown cell type: " + cellType);
    }

    static CellValue createFromValue(Object value, TypeDefinition typeDef) throws DataTypeException {
        if (typeDef.isStrict() && !typeDef.getType().isInstance(value)) {
            String valueType = value == null ? "[NULL]" : value.getClass().getName();
            throw new DataTypeException("Value type " + valueType + " does not match the defined type " + typeDef.getType().getName());
        }
        return new CellValue(value, typeDef);
    }

    CellValue(Object value, TypeDefinition typeDef) {
        this.value = value;
        this.typeDef = typeDef;
    }

    public Date getDate(String formatPattern) throws DataTypeException {
        if (formatPattern == null) {
            throw new IllegalArgumentException("Format pattern must not be null");
        }
        if (this.value instanceof Date) {
            return (Date)this.value;
        }
        if (this.value instanceof String) {
            SimpleDateFormat f = new SimpleDateFormat(formatPattern);
            try {
                return f.parse((String)this.value);
            }
            catch (ParseException e) {
                throw new DataTypeException("The value does not adhere to the specified format ('" + formatPattern + "')");
            }
        }
        throw new DataTypeException("The value is no date");
    }

    public Double getDouble() throws DataTypeException {
        if (this.value == null) {
            return null;
        }
        if (this.value instanceof Number) {
            return new Double(((Number)this.value).doubleValue());
        }
        if (this.value instanceof String) {
            try {
                return Double.valueOf((String)this.value);
            }
            catch (NumberFormatException e) {
                throw new DataTypeException("The value is not a number");
            }
        }
        throw new DataTypeException("The value is not a number");
    }

    public Double getDouble(String formatPattern, Locale locale) throws DataTypeException {
        if (this.value == null) {
            return null;
        }
        if (this.value instanceof Number) {
            return new Double(((Number)this.value).doubleValue());
        }
        if (this.value instanceof String) {
            DecimalFormat f = (DecimalFormat)DecimalFormat.getInstance(locale);
            f.applyPattern(formatPattern);
            try {
                double d = f.parse((String)this.value).doubleValue();
                return new Double(d);
            }
            catch (ParseException e) {
                throw new DataTypeException("The value is not a number");
            }
        }
        throw new DataTypeException("The value is not a number");
    }

    public Long getLong() throws DataTypeException {
        if (this.value == null) {
            return null;
        }
        if (this.value instanceof Number) {
            return new Long(((Number)this.value).longValue());
        }
        if (this.value instanceof String) {
            try {
                return Long.valueOf((String)this.value);
            }
            catch (NumberFormatException e) {
                throw new DataTypeException("The value is not a number");
            }
        }
        throw new DataTypeException("The value is not a number");
    }

    public BigDecimal getMonetaryValue(String formatPattern, Locale locale) throws DataTypeException {
        if (this.value == null) {
            return null;
        }
        Double doubleValue = this.getDouble(formatPattern, locale);
        double d = doubleValue;
        BigDecimal dec = new BigDecimal(d);
        return dec.setScale(2, 4);
    }

    public String getString() {
        if (this.value == null) {
            return null;
        }
        return this.value.toString();
    }

    public TypeDefinition getTypeDef() {
        return this.typeDef;
    }

    public Object getValue() {
        return this.value;
    }

    WritableCell getWritableCell(int rowIndex, int columnIndex) {
        throw new UnsupportedOperationException();
    }

    public boolean isCorrectType() {
        return this.typeDef.getType().isInstance(this.value);
    }

    public String toString() {
        String typeName = this.value == null ? "[NULL]" : this.value.getClass().getName();
        return this.value + " [actual type = " + typeName + ", expected type = " + this.typeDef.getType().getName() + ", strict type def = " + this.typeDef.isStrict() + "]";
    }
}

