/*
 * Decompiled with CFR 0.152.
 */
package com.aparzev.doka.ms.excel;

import com.aparzev.doka.ms.excel.ColumnDefinition;
import com.aparzev.doka.ms.excel.TypeDefinition;
import com.aparzev.doka.xml.Selector;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SchemaDefinition {
    private ColumnDefinition[] columnDefs;
    private Map columnIndexMap = new HashMap();
    private int mappingRow;
    private String name;
    private int rowOffset;

    SchemaDefinition() {
    }

    public SchemaDefinition(InputStream in) throws ParserConfigurationException, SAXException, IOException, ClassNotFoundException {
        this.readSchema(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchemaDefinition(String filename) throws ParserConfigurationException, SAXException, IOException, ClassNotFoundException {
        InputStream in = null;
        try {
            in = this.getClass().getResourceAsStream(filename);
            this.readSchema(in);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public int getColumnCount() {
        return this.columnDefs.length;
    }

    private ColumnDefinition getColumnDef(Node columnNode) throws ClassNotFoundException {
        String columnName = Selector.getStringAttribute(columnNode, "name");
        String columnCaption = Selector.getStringAttribute(columnNode, "caption");
        String columnType = Selector.getStringAttribute(columnNode, "type");
        String strictAttribute = Selector.getStringAttribute(columnNode, "strict");
        boolean strict = strictAttribute == null ? false : Boolean.valueOf(strictAttribute);
        Class<?> type = Class.forName(columnType);
        TypeDefinition typeDef = new TypeDefinition(type, strict);
        return new ColumnDefinition(columnName, typeDef, columnCaption);
    }

    public ColumnDefinition[] getColumnDefs() {
        return this.columnDefs;
    }

    public int getColumnIndex(String columnName) {
        if (columnName == null) {
            throw new IllegalArgumentException("Column name must not be null");
        }
        Integer index = (Integer)this.columnIndexMap.get(columnName);
        if (index == null) {
            throw new IllegalArgumentException("Unknown column '" + columnName + "'");
        }
        return index;
    }

    public int getMappingRow() {
        return this.mappingRow;
    }

    public String getName() {
        return this.name;
    }

    public int getRowOffset() {
        return this.rowOffset;
    }

    private void getSchemaAttributes(Node root) {
        this.name = Selector.getStringAttribute(root, "name");
        String rowOffsetAttribute = Selector.getStringAttribute(root, "rowOffset");
        this.rowOffset = Integer.parseInt(rowOffsetAttribute);
        String mappingRowAttribute = Selector.getStringAttribute(root, "mappingRow");
        this.mappingRow = Integer.parseInt(mappingRowAttribute);
    }

    private void readSchema(InputStream in) throws FactoryConfigurationError, ParserConfigurationException, SAXException, IOException, ClassNotFoundException {
        if (in == null) {
            throw new IllegalArgumentException("Input stream must not be null");
        }
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = builderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(in);
        Element root = document.getDocumentElement();
        this.getSchemaAttributes(root);
        Node columnsNode = Selector.selectSingleNode(root, "columns");
        NodeList columnNodes = Selector.selectNodeList(columnsNode, "column");
        int columnNodesLength = columnNodes.getLength();
        this.columnDefs = new ColumnDefinition[columnNodesLength];
        for (int i = 0; i < columnNodesLength; ++i) {
            ColumnDefinition columnDef;
            Node columnNode = columnNodes.item(i);
            this.columnDefs[i] = columnDef = this.getColumnDef(columnNode);
            String columnName = columnDef.getName();
            Integer columnIndex = new Integer(i);
            this.columnIndexMap.put(columnName, columnIndex);
        }
    }
}

