/*
 * Decompiled with CFR 0.152.
 */
package com.aparzev.doka.ms.excel;

import com.aparzev.doka.DocumentException;
import com.aparzev.doka.ms.excel.CellValue;
import com.aparzev.doka.ms.excel.ColumnDefinition;
import com.aparzev.doka.ms.excel.DataTypeException;
import com.aparzev.doka.ms.excel.SchemaDefinition;
import com.aparzev.doka.ms.excel.SchemaException;
import com.aparzev.doka.ms.excel.TypeDefinition;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;
import jxl.read.biff.BiffException;
import org.apache.commons.lang.StringUtils;

public class Spreadsheet {
    private List rows = new ArrayList();
    private SchemaDefinition schema;

    public Spreadsheet(SchemaDefinition schema) {
        this.schema = schema;
    }

    private void addRow(Cell[] values) throws DataTypeException {
        ColumnDefinition[] columnDefs = this.schema.getColumnDefs();
        int columnCount = columnDefs.length;
        CellValue[] row = new CellValue[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            ColumnDefinition columnDef = columnDefs[i];
            TypeDefinition typeDef = columnDef.getTypeDef();
            Cell cell = values[i];
            row[i] = CellValue.createFromCell(cell, typeDef);
        }
        this.rows.add(row);
    }

    public void addRow(Map values) throws DataTypeException {
        if (values == null) {
            throw new IllegalArgumentException("Value map must not be null");
        }
        ColumnDefinition[] columnDefs = this.schema.getColumnDefs();
        CellValue[] row = new CellValue[columnDefs.length];
        for (int i = 0; i < columnDefs.length; ++i) {
            ColumnDefinition columnDef = columnDefs[i];
            String name = columnDef.getName();
            TypeDefinition typeDef = columnDef.getTypeDef();
            Object value = values.remove(name);
            row[i] = CellValue.createFromValue(value, typeDef);
        }
        if (values.size() > 0) {
            Iterator iter = values.keySet().iterator();
            String columnNames = StringUtils.join(iter, (String)", ");
            throw new IllegalArgumentException("Unknown column names: " + columnNames);
        }
        this.rows.add(row);
    }

    public CellValue[] getColumnValues(String columnName) {
        int rowCount = this.getRowCount();
        CellValue[] values = new CellValue[rowCount];
        int columnIndex = this.schema.getColumnIndex(columnName);
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            CellValue[] row = (CellValue[])this.rows.get(rowIndex);
            values[rowIndex] = row[columnIndex];
        }
        return values;
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public CellValue getValue(int rowIndex, String columnName) {
        if (rowIndex < 0 || rowIndex >= this.rows.size()) {
            throw new IllegalArgumentException("Row index is out of bounds");
        }
        int columnIndex = this.schema.getColumnIndex(columnName);
        CellValue[] row = (CellValue[])this.rows.get(rowIndex);
        return row[columnIndex];
    }

    public CellValue[][] getValues() {
        CellValue[][] values = new CellValue[this.getRowCount()][this.schema.getColumnCount()];
        for (int i = 0; i < this.rows.size(); ++i) {
            values[i] = (CellValue[])this.rows.get(i);
        }
        return values;
    }

    public void readSpreadsheet(InputStream in) throws IOException, DataTypeException, DocumentException {
        this.readSpreadsheet(in, 0);
    }

    public void readSpreadsheet(InputStream in, int index) throws IOException, DataTypeException, SchemaException, DocumentException {
        this.rows.clear();
        Workbook workbook = null;
        try {
            int rowOffset;
            workbook = Workbook.getWorkbook(in);
            Sheet sheet = workbook.getSheet(index);
            int rowCount = sheet.getRows();
            int columnCount = sheet.getColumns();
            int schemaColumnCount = this.schema.getColumnCount();
            if (columnCount != schemaColumnCount) {
                throw new SchemaException("Number of columns in the spreadsheet " + columnCount + " is not equal to the column count " + schemaColumnCount + " in the schema");
            }
            for (int i = rowOffset = this.schema.getRowOffset(); i < rowCount; ++i) {
                LinkedList<Cell> row = new LinkedList<Cell>();
                for (int j = 0; j < columnCount; ++j) {
                    Cell cell = sheet.getCell(j, i);
                    if (cell.isHidden()) continue;
                    row.add(cell);
                }
                this.addRow(row.toArray(new Cell[row.size()]));
            }
        }
        catch (BiffException e) {
            throw new DocumentException(e.getMessage(), e);
        }
        catch (IndexOutOfBoundsException e) {
            throw new DocumentException(e.getMessage(), e);
        }
        finally {
            if (workbook != null) {
                workbook.close();
            }
        }
    }
}

