/*
 * Decompiled with CFR 0.152.
 */
package com.aparzev.doka.ms.excel.legacy;

import com.aparzev.doka.ms.excel.legacy.SpreadSheetSchema;
import com.aparzev.doka.ms.excel.legacy.SpreadSheetSchemaColumn;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SpreadSheetData {
    private String[] columnNames;
    private Map columnNamesMap = new HashMap();
    private List rows = new ArrayList();
    private SpreadSheetSchema schema;

    public SpreadSheetData(SpreadSheetSchema schema) {
        this.schema = schema;
        this.columnNames = new String[schema.getColumnCount()];
        this.setColumnNames();
    }

    public void setColumnNames() {
        List columns = this.schema.getColumns();
        Iterator it = columns.iterator();
        int i = 0;
        while (it.hasNext()) {
            SpreadSheetSchemaColumn column = (SpreadSheetSchemaColumn)it.next();
            this.setColumnName(i++, column.getName());
        }
    }

    public void setColumnName(int index, String name) {
        this.columnNames[index] = name;
        this.columnNamesMap.put(name, new Integer(index));
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public int getColumnCount() {
        return this.schema.getColumnCount();
    }

    public SpreadSheetSchema getSchema() {
        return this.schema;
    }

    public void addRow(String[] data) {
        if (data.length != this.schema.getColumnCount()) {
            throw new IllegalArgumentException("Size of data array doesn't match column count!");
        }
        this.rows.add(data);
    }

    public void addRow(Map data) {
        String[] dataArray = new String[this.schema.getColumnCount()];
        Iterator iter = data.keySet().iterator();
        while (iter.hasNext()) {
            String columnName = (String)iter.next();
            int index = this.schema.getColumnByName(columnName).getIndex();
            dataArray[index] = (String)data.get(columnName);
        }
        this.addRow(dataArray);
    }

    public String getColumnName(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.schema.getColumnCount()) {
            throw new IllegalArgumentException("Column index out of bounds: " + columnIndex);
        }
        return this.columnNames[columnIndex];
    }

    public String getField(int rowIndex, String columnName) {
        if (rowIndex < 0 || rowIndex >= this.rows.size()) {
            throw new IllegalArgumentException("Row index out of bounds: " + rowIndex);
        }
        if (!this.columnNamesMap.containsKey(columnName)) {
            throw new IllegalArgumentException("Unknown column name: " + columnName);
        }
        String[] rowData = (String[])this.rows.get(rowIndex);
        int columnIndex = (Integer)this.columnNamesMap.get(columnName);
        return rowData[columnIndex];
    }
}

