/*
 * Decompiled with CFR 0.152.
 */
package com.aparzev.doka.ms.excel.legacy;

import com.aparzev.doka.ms.excel.legacy.SpreadSheetData;
import com.aparzev.doka.ms.excel.legacy.SpreadSheetReaderException;
import com.aparzev.doka.ms.excel.legacy.SpreadSheetSchema;
import com.aparzev.doka.ms.excel.legacy.SpreadSheetSchemaColumn;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;
import jxl.read.biff.BiffException;

public class SpreadSheetReader {
    private SpreadSheetSchema schema;
    private List columnMapping;

    public SpreadSheetReader(SpreadSheetSchema schema) {
        this.schema = schema;
    }

    public SpreadSheetData readSpreadSheet(InputStream stream) throws SpreadSheetReaderException {
        SpreadSheetData data = new SpreadSheetData(this.schema);
        Workbook inputWorkbook = null;
        try {
            inputWorkbook = Workbook.getWorkbook(stream);
            Sheet inputSheet = inputWorkbook.getSheet(0);
            this.readColumnMapping(inputSheet);
            this.readRows(inputSheet, data);
            inputWorkbook.close();
        }
        catch (IOException e) {
            throw new SpreadSheetReaderException("Unable to open workbook!", 2);
        }
        catch (BiffException e) {
            throw new SpreadSheetReaderException("Unable to open workbook!", 2);
        }
        finally {
            if (inputWorkbook != null) {
                inputWorkbook.close();
            }
        }
        return data;
    }

    private void readColumnMapping(Sheet spreadSheet) throws SpreadSheetReaderException {
        this.columnMapping = new ArrayList();
        for (int columnIndex = 0; columnIndex < this.schema.getColumnCount(); ++columnIndex) {
            Cell cell = spreadSheet.getCell(columnIndex, this.schema.getMappingRow());
            boolean hidden = cell.isHidden();
            if (hidden) continue;
            String caption = cell.getContents();
            try {
                SpreadSheetSchemaColumn column = this.schema.getColumnByCaption(caption);
                this.columnMapping.add(columnIndex, column);
                continue;
            }
            catch (IllegalArgumentException e) {
                throw new SpreadSheetReaderException("Unable to read column mapping from row " + this.schema.getMappingRow() + ", column " + columnIndex + ", caption: " + caption, 3, caption);
            }
        }
    }

    private void readRows(Sheet spreadSheet, SpreadSheetData data) {
        for (int i = this.schema.getRowOffset(); i < spreadSheet.getRows(); ++i) {
            this.readRow(spreadSheet, i, data);
        }
    }

    private void readRow(Sheet spreadSheet, int rowIndex, SpreadSheetData data) {
        String[] rowData = new String[this.schema.getColumnCount()];
        for (int columnIndex = 0; columnIndex < this.schema.getColumnCount(); ++columnIndex) {
            Cell cell = spreadSheet.getCell(columnIndex, rowIndex);
            int mappedIndex = ((SpreadSheetSchemaColumn)this.columnMapping.get(columnIndex)).getIndex();
            rowData[mappedIndex] = cell.getContents();
        }
        data.addRow(rowData);
    }
}

