/*
 * Decompiled with CFR 0.152.
 */
package com.aparzev.doka.ms.excel.legacy;

import com.aparzev.doka.ms.excel.legacy.SpreadSheetSchemaColumn;
import java.util.Iterator;
import java.util.List;

public class SpreadSheetSchema {
    private String name;
    private int rowOffset = 0;
    private int mappingRow;
    private List columns;

    public SpreadSheetSchema(String name, int rowOffset, int mappingRow) {
        this.name = name;
        this.rowOffset = rowOffset;
        this.mappingRow = mappingRow;
    }

    public SpreadSheetSchemaColumn getColumn(int index) {
        if (index < 0 || index > this.columns.size() - 1) {
            throw new IllegalArgumentException("Column index out of bounds: " + index);
        }
        return (SpreadSheetSchemaColumn)this.columns.get(index);
    }

    public SpreadSheetSchemaColumn getColumnByCaption(String caption) {
        Iterator iter = this.columns.iterator();
        while (iter.hasNext()) {
            SpreadSheetSchemaColumn column = (SpreadSheetSchemaColumn)iter.next();
            if (!caption.equalsIgnoreCase(column.getCaption())) continue;
            return column;
        }
        throw new IllegalArgumentException("Unknown column caption: " + caption);
    }

    public SpreadSheetSchemaColumn getColumnByName(String name) {
        Iterator iter = this.columns.iterator();
        while (iter.hasNext()) {
            SpreadSheetSchemaColumn column = (SpreadSheetSchemaColumn)iter.next();
            if (!name.equalsIgnoreCase(column.getName())) continue;
            return column;
        }
        throw new IllegalArgumentException("Unknown column name: " + name);
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public List getColumns() {
        return this.columns;
    }

    public void setColumns(List columns) {
        this.columns = columns;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int getRowOffset() {
        return this.rowOffset;
    }

    public int getMappingRow() {
        return this.mappingRow;
    }
}

